<?php
declare(strict_types=1);
namespace src\application\media;

use Exception;
use src\domain\media\FilePdf;
use src\domain\media\MediaUpload;

class DeletePdfService {

    private $mediaUpload;

	public function __construct( MediaUpload $mediaUpload ){

        $this->mediaUpload = $mediaUpload;    
    }
    
    public function execute( UploadFileRequest $request ) : array{

        try{

            $file = $request->getFile();
            $nameFile = $file['name'];
            $extension = explode(".",$nameFile);
            $long = count($extension) - 1;

            $filePdf = new FilePdf($extension[0],'',$extension[$long]);
            if( $this->mediaUpload->removeFile( $filePdf->getLocation()) ){

                return [ "success" => true ];

            }else{

                throw new Exception('Error al eliminar el archivo.');

            }
            

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
