<?php
declare(strict_types=1);
namespace src\application\login;

use src\domain\event\LogEventData;

class UserClosedSession extends LogEventData {

    private $section;

	public function __construct(int $user, string $section){

        $this->section = $section;
        parent::__construct($user);
	}

    public function getSection() : string {
        return $this->section;
    }
    
    public function getAction() : string {
        return 'Cerr&oacute; sesi&oacute;n ';
    }

}
?>
