<?php
declare(strict_types=1);
namespace src\application\login;

use Exception;
use src\infrastructure\sql\SqlLogEventStore;
use src\domain\user\UserRepository;
use src\EmailInterface;
use src\application\RecoveryPassword;
use src\application\Authentication;
use src\domain\event\LogEventPublisher;
use src\domain\event\LogEventSaveSubscriber;

class LoginProvider {

    private $emailSender;
    private $userRepository;

	public function __construct( UserRepository $userRepository, EmailInterface $email ){

        $this->emailSender = $email;
        $this->userRepository = $userRepository;    
        LogEventPublisher::instance()->subscribe(new LogEventSaveSubscriber( new SqlLogEventStore() ));

	}

    public function execute( LoginRequest $request ){

        try{

            if( $request->gettype() == 'login'){
    
                $auth = new Authentication($request->getEmail(),$request->getPassword(),$this->userRepository);
                $auth->login('user');
                $userLogin = $auth->getUserAuth();
                if($userLogin->type != 1){
                    return array("success"=>true,"message"=>"","user"=>$userLogin);
                }
    
            }
            if( $request->gettype() == 'recovery'){
    
                $recovery = new RecoveryPassword($this->emailSender,$this->userRepository,$request->getEmail());
			    return array("success"=>$recovery->execute(),"message"=>"Se ha enviado una nueva clave a su email");
    
            }

        }catch(Exception $e){

			throw new Exception($e->getMessage());

		}



    }
}
?>
