<?php
declare(strict_types=1);
namespace src\application\login;

use src\infrastructure\sql\SqlLogEventStore;
use src\application\Authentication;
use src\domain\event\LogEventPublisher;
use src\domain\event\LogEventSaveSubscriber;

class LogOut {

    private $userLogin;

	public function __construct( ){
    
        $this->userLogin = Authentication::getUserAuth();
        LogEventPublisher::instance()->subscribe(new LogEventSaveSubscriber( new SqlLogEventStore() ));

	}

    public function execute( string $typeUser ){

        Authentication::logOut();
        LogEventPublisher::instance()->publish(
            new UserClosedSession($this->userLogin->id,$typeUser)
        );

    }
}
?>
