<?php
declare(strict_types=1);
namespace src\application\log;

use src\application\Authorization;
use src\domain\event\LogEventStore;
use src\application\exception\UserInvalid;
use src\application\exception\SessionExpire;

class LogList{

    private $LogRepository;
    private $authorization;

	public function __construct( LogEventStore $logRepository ){

        $this->LogRepository = $logRepository;
        $this->authorization = new Authorization();    
    }

    private function checkAuthorization(){

        if( !$this->authorization->isLogin() ){
    
            throw new SessionExpire();
        
        }else{

            if(!$this->authorization->isAdmin()){

                throw new UserInvalid();

            }


        }

    }
    
    public function execute( LogListRequest $request ) : array{

        $this->checkAuthorization();

        try{
            
            return [
                "registers" => json_encode($this->LogRepository->search($request->getSearch(),$request->getLimit())),
                "total" => $this->LogRepository->totalSearch($request->getSearch())
            ];

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
