<?php
declare(strict_types=1);
namespace src\application\document;

use src\domain\document\Document;
use src\domain\document\DocumentDTO;
use src\domain\document\DocumentCategory;

class DocumentUpdate extends DocumentService {

    private function transformRequestToDTO (Document $document, DocumentRequest $request ) : DocumentDTO{

        $documentDTO = new DocumentDTO($document);
        
        $documentDTO->name = $request->getName();
        $documentDTO->provider = $request->getProvider();
        $documentDTO->date = $request->getDate();
        $documentDTO->typeUser = $request->getTypeUser();
        if($request->getFile() != ''){

            $documentDTO->file = $request->getFile();
        
        }
        $documentDTO->userUpdate = $this->userLogin->id;

        return $documentDTO;

    }
    
    public function execute( DocumentRequest $request ) : array{

        $this->checkAuthorization($request->getId());

        try{

            $document = $this->documentRepository->getDocument('id',$request->getId());
            $category = $this->categoryRepository->getCategory('id',$request->getIdCategory());

            $errors = Document::canSave( 
                $request->getName(), 
                $request->getFile(),
                new DocumentCategory($category->getId(),$category->getName()) );
            if( $errors->hasError() ){

                throw new Exception($errors->printErrors());
                
            }

            $documentDTO = $this->transformRequestToDTO($document,$request);
            $documentDTO->idCategory = $category->getId();
            $documentDTO->nameCategory = $category->getName();

            $document->update( $documentDTO );

            $this->documentRepository->update($document);
            
            $this->sendEmailProviders($document->getProvider(),$request->getName());
            
            return array("success"=>true,"message"=>"Archivo modificado exitosamente",'document'=>new DocumentDTO($document));
            

        }catch(Exception $e){

			throw new Exception($e->getMessage());

		}



    }
}
?>
