<?php
declare(strict_types=1);
namespace src\application\document;

use src\EmailInterface;
use src\application\Authorization;
use src\application\Authentication;
use src\domain\user\UserRepository;
use src\domain\event\LogEventPublisher;
use src\application\exception\UserInvalid;
use src\domain\document\CategoryRepository;
use src\domain\document\DocumentRepository;
use src\application\exception\SessionExpire;
use src\domain\event\LogEventSaveSubscriber;
use src\infrastructure\sql\SqlLogEventStore;

abstract class DocumentService {

    protected $documentRepository;
    protected $categoryRepository;
    protected $providerRepository;
    protected $authorization;
    protected $email;
    protected $userLogin;

	public function __construct( EmailInterface $email, DocumentRepository $documentRepository, CategoryRepository $categoryRepository, UserRepository $providerRepository){

        $this->email = $email;
        $this->providerRepository = $providerRepository;
        $this->categoryRepository = $categoryRepository;
        $this->documentRepository = $documentRepository;
        $this->authorization = new Authorization();
        $this->userLogin = Authentication::getUserAuth();
        LogEventPublisher::instance()->subscribe(new LogEventSaveSubscriber( new SqlLogEventStore() ));    
    }
    
    
    protected function checkAuthorization(){
        
        if( !$this->authorization->isLogin() ){
            
            throw new SessionExpire();
            
        }else{
            
            if(!$this->authorization->isAdmin()){
                
                throw new UserInvalid();
                
            }
            
        }
        
    }

    protected function sendEmailProviders(array $providers, string $nameDocument){

        $textEmail = 'le informamos que tiene un nuevo documento disponible para su visualizacion en nuestro sistema.
                    <p><strong>Nombre del documento:</strong> '.$nameDocument.'.</p>';

        if(count($providers)){

            foreach($providers as $idProvider){


                $provider = $this->providerRepository->getUser('id',$idProvider);
                $this->email->notification(ucwords($provider->getName()),$provider->getEmail(),$textEmail,'Nuevo Documento');

            }

        }

    }
    
    public abstract function execute( DocumentRequest $request ) : array;
}
?>
