<?php
declare(strict_types=1);
namespace src\application\document;

class DocumentRequest{

    private $id;
    private $name;
    private $idCategory;
    private $provider;
    private $typeUser;
    private $date;
    private $file;
    private $status;

	public function __construct( int $id,string $name, string $file, string $idCategory, array $provider, int $typeUser, string $date, int $status){
            
        $this->id = $id;
        $this->name = $name;
        $this->idCategory = $idCategory;
        $this->provider = $provider;
        $this->typeUser = $typeUser;
        if($date != ''){
            $this->date = date('Y-m-d',strtotime($date));
        }else{
            $this->date = '0000-00-00';
        }
        $this->file = $file;
        $this->status = $status;
    }

    public function getId(){
        return $this->id;
    }

    public function getName(){
        return $this->name;
    }
    
    public function getFile(){
        return $this->file;
    }
    
    public function getIdCategory(){
        return $this->idCategory;
    }

    public function getStatus(){
        return $this->status;
    }

    public function getProvider(){
        return $this->provider;
    }

    public function getDate(){
        return $this->date;
    }

    public function getTypeUser(){
        return $this->typeUser;
    }
}
?>
