<?php
declare(strict_types=1);
namespace src\application\document;

use src\application\Authorization;
use src\domain\document\DocumentDTO;
use src\application\exception\UserInvalid;
use src\domain\document\DocumentRepository;
use src\application\exception\SessionExpire;

class DocumentList{

    private $documentRepository;
    private $authorization;

	public function __construct( DocumentRepository $documentRepository ){

        $this->documentRepository = $documentRepository;
        $this->authorization = new Authorization();    
    }

    private function transformToDTO( array $documents ) : array{

        $documentsDto = array();

        if( count($documents) ){

            foreach($documents as $document){

                $documentsDto[] = new DocumentDTO($document);

            }

        }

        return $documentsDto;

    }

    private function checkAuthorization(){

        if( !$this->authorization->isLogin() ){
    
            throw new SessionExpire();
        
        }

    }
    
    public function execute( DocumentListRequest $request ) : array{

        $this->checkAuthorization();

        try{
            
            return [
                "registers" => $this->transformToDTO(
                    $this->documentRepository->search($request->getSearch(),$request->getLimit())
                ),
                "total" => $this->documentRepository->totalSearch($request->getSearch())
            ];

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
