<?php
declare(strict_types=1);
namespace src\application\document;

use src\application\Authorization;
use src\domain\document\DocumentDTO;
use src\application\exception\UserInvalid;
use src\domain\document\DocumentRepository;
use src\application\exception\SessionExpire;

class DocumentGet{

    private $documentRepository;
    private $authorization;

	public function __construct( DocumentRepository $documentRepository ){

        $this->documentRepository = $documentRepository;
        $this->authorization = new Authorization();    
    }

    private function checkAuthorization(){
        
        if( !$this->authorization->isLogin() ){
            
            throw new SessionExpire();
            
        }else{
            
            if(!$this->authorization->isAdmin()){
                
                throw new UserInvalid();
                
            }
            
        }
        
    }

    public function execute( DocumentGetRequest $request ) : array{

        $this->checkAuthorization();

        try{
            
            return [
                "document" => new DocumentDTO( $this->documentRepository->getDocument($request->getField(),$request->getId()) ),
            ];

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
