<?php
declare(strict_types=1);
namespace src\application\document;

class DocumentDelete extends DocumentService {

    public function execute( DocumentRequest $request ) : array{

        $this->checkAuthorization();

        try{

            $document = $this->documentRepository->getDocument('id',$request->getId());

            $document->delete( $this->userLogin->id );

            $this->documentRepository->delete($document);

            unlink('../../file/'.$document->getFile());

            return array("success"=>true,"file"=>$document->getFile(),"message"=>"Archivo eliminado exitosamente");
            

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
