<?php
declare(strict_types=1);
namespace src\application\document;

use src\domain\document\Category;
use src\domain\document\Document;
use src\domain\document\DocumentDTO;
use src\domain\document\DocumentCategory;
use src\application\document\DocumentService;


class DocumentCreate extends DocumentService {
    
    public function execute( DocumentRequest $request ) : array{

        $this->checkAuthorization();
        
        try{
            
            $category = $this->categoryRepository->getCategory('id',$request->getIdCategory());

            $errors = Document::canSave( 
                $request->getName(), 
                $request->getFile(),
                new DocumentCategory($category->getId(),$category->getName()) );

            if( $errors->hasError() ){

                throw new \Exception($errors->printErrors());
                
            }

            $document = new Document( 
                NULL,
                $request->getName(),
                $request->getFile(),
                $category->getId(),
                $category->getName(),
                $request->getProvider(),
                $request->getTypeUser(),
                $request->getDate(),
                1,
                $this->userLogin->id,
                $this->userLogin->id,
                date('Y-m-d H:i:s'),
                date('Y-m-d H:i:s')
            );
            $this->documentRepository->add( $document );
            $this->sendEmailProviders($document->getProvider(),$request->getName());

            return array("success"=>true,"message"=>"Archivo creado exitosamente",'document'=>new DocumentDTO($document));
            

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
