<?php
declare(strict_types=1);
namespace src\application\document;

use src\domain\document\DocumentDTO;

class DocumentChangeStatus extends DocumentService {

    
    public function execute( DocumentRequest $request ) : array{

        $this->checkAuthorization();

        try{

            $document = $this->documentRepository->getDocument('id',$request->getId());

            $document->changeStatus( $request->getStatus(), $this->userLogin->id );

            $this->documentRepository->changeStatus($document);

            return array("success"=>true,"message"=>"Archivo modificada exitosamente",'document'=>new DocumentDTO($document));
            

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
