<?php
declare(strict_types=1);
namespace src\application\category;

use src\domain\document\Category;
use src\domain\document\CategoryDTO;
use src\domain\document\CategoryProvider;
use src\domain\document\CategoryRepository;
use src\domain\validation\ValidationHandler;

class CategoryUpdate extends CategoryService {

    private function transformRequestToDTO (Category $category, CategoryRequest $request ) : CategoryDTO{

        $categoryDTO = new CategoryDTO($category);
        
        $categoryDTO->name = $request->getName();
        $categoryDTO->ico = $request->getIco();
        $categoryDTO->userUpdate = $this->userLogin->id;

        return $categoryDTO;

    }
    
    public function execute( CategoryRequest $request ) : array{

        $this->checkAuthorization($request->getId());

        try{

            $category = $this->categoryRepository->getCategory('id',$request->getId());
            
            $errors = $category->canSave( $request->getName());
            if( $errors->hasError() ){

                throw new Exception($errors->printErrors());
                
            }

            $category->update( $this->transformRequestToDTO( $category, $request),$providerCategory );

            $this->categoryRepository->update($category);

            return array("success"=>true,"message"=>"Categor&iacute;a modificada exitosamente",'category'=>new CategoryDTO($category));
            

        }catch(Exception $e){

			throw new Exception($e->getMessage());

		}



    }
}
?>
