<?php
declare(strict_types=1);
namespace src\application\category;

use src\application\Authorization;
use src\application\Authentication;
use src\domain\event\LogEventPublisher;
use src\application\exception\UserInvalid;
use src\domain\document\CategoryRepository;
use src\application\exception\SessionExpire;
use src\domain\event\LogEventSaveSubscriber;
use src\infrastructure\sql\SqlLogEventStore;

abstract class CategoryService {

    protected $categoryRepository;
    protected $authorization;
    protected $userLogin;

	public function __construct( CategoryRepository $categoryRepository ){

        $this->categoryRepository = $categoryRepository;
        $this->authorization = new Authorization();
        $this->userLogin = Authentication::getUserAuth();
        LogEventPublisher::instance()->subscribe(new LogEventSaveSubscriber( new SqlLogEventStore() ));    
    }
    
    
    protected function checkAuthorization(){
        
        if( !$this->authorization->isLogin() ){
            
            throw new SessionExpire();
            
        }else{
            
            if(!$this->authorization->isAdmin()){
                
                throw new UserInvalid();
                
            }
            
        }
        
    }
    
    public abstract function execute( CategoryRequest $request ) : array;
}
?>
