<?php
declare(strict_types=1);
namespace src\application\category;

use src\domain\document\CategoryDTO;
use src\application\Authorization;
use src\domain\document\CategoryRepository;
use src\application\exception\UserInvalid;
use src\application\exception\SessionExpire;

class CategoryList{

    private $categoryRepository;
    private $authorization;

	public function __construct( CategoryRepository $categoryRepository ){

        $this->categoryRepository = $categoryRepository;
        $this->authorization = new Authorization();    
    }

    private function transformToDTO( array $categories ) : array{

        $categoriesDto = array();

        if( count($categories) ){

            foreach($categories as $category){

                $categoriesDto[] = new CategoryDTO($category);

            }

        }

        return $categoriesDto;

    }

    private function checkAuthorization(){

        if( !$this->authorization->isLogin() ){
    
            throw new SessionExpire();
        
        }

    }
    
    public function execute( CategoryListRequest $request ) : array{

        $this->checkAuthorization();

        try{
            
            return [
                "registers" => $this->transformToDTO(
                    $this->categoryRepository->search($request->getSearch(),$request->getLimit())
                ),
                "total" => $this->categoryRepository->totalSearch($request->getSearch())
            ];

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
