<?php
declare(strict_types=1);
namespace src\application\category;

use src\application\Authorization;
use src\domain\document\CategoryDTO;
use src\application\exception\UserInvalid;
use src\domain\document\CategoryRepository;
use src\application\exception\SessionExpire;

class CategoryGet{

    private $categoryRepository;
    private $authorization;

	public function __construct( CategoryRepository $categoryRepository ){

        $this->categoryRepository = $categoryRepository;
        $this->authorization = new Authorization();    
    }

    private function checkAuthorization(){
        
        if( !$this->authorization->isLogin() ){
            
            throw new SessionExpire();
            
        }
        
    }

    public function execute( CategoryGetRequest $request ) : array{

        $this->checkAuthorization();

        try{
            
            return [
                "category" => new CategoryDTO( $this->categoryRepository->getCategory($request->getField(),$request->getId()) ),
            ];

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
