<?php
declare(strict_types=1);
namespace src\application\category;

class CategoryDelete extends CategoryService {

    public function execute( CategoryRequest $request ) : array{

        $this->checkAuthorization();

        try{

            $category = $this->categoryRepository->getCategory('id',$request->getId());

            $category->delete( $this->userLogin->id );

            $this->categoryRepository->delete($category);

            return array("success"=>true,"message"=>"Categor&iacute;a eliminada exitosamente");
            

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
