<?php
declare(strict_types=1);
namespace src\application\category;

use src\domain\document\Category;
use src\domain\document\CategoryDTO;
use src\domain\document\CategoryProvider;
use src\domain\document\CategoryRepository;
use src\domain\validation\ValidationHandler;

class CategoryCreate extends CategoryService {
    
    public function execute( CategoryRequest $request ) : array{

        $this->checkAuthorization();
        
        try{

            $type = 0;
            $errors = Category::canSave( $request->getName() );

            if( $errors->hasError() ){

                throw new \Exception($errors->printErrors());
                
            }

            if($this->userLogin->type == 4){
                $type = 1;
            }
            if($this->userLogin->type == 5){
                $type = 2;
            }

            $category = new Category( 
                NULL,
                $request->getName(), 
                $request->getIco(),
                1,
                $type,
                $this->userLogin->id,
                $this->userLogin->id,
                date('Y-m-d H:i:s'),
                date('Y-m-d H:i:s')
            );
            $this->categoryRepository->add( $category );
            return array("success"=>true,"message"=>"Categor&iacute;a creado exitosamente",'provider'=>new CategoryDTO($category));
            

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
