<?php
declare(strict_types=1);
namespace src\application\category;

use src\domain\document\CategoryDTO;

class CategoryChangeStatus extends CategoryService {

    
    public function execute( CategoryRequest $request ) : array{

        $this->checkAuthorization();

        try{

            $category = $this->categoryRepository->getCategory('id',$request->getId());

            $category->changeStatus( $request->getStatus(), $this->userLogin->id );

            $this->categoryRepository->changeStatus($category);

            return array("success"=>true,"message"=>"Categor&iacute;a modificada exitosamente",'category'=>new CategoryDTO($category));
            

        }catch(\Exception $e){

			throw new \Exception($e->getMessage());

		}



    }
}
?>
