<?php
declare(strict_types=1);
namespace src\application;

use Exception;
use \Firebase\JWT\JWT;
use src\domain\user\UserDTO;

require_once $GLOBALS['app_root']."/src/utils/jwt/vendor/autoload.php";

class TokenValidEmail{

	public function __construct(){}

    public function setData($user){

        $key = 'validaEmailDocument';
        $time = time();
        $token = array(
                    "iat" => $time,
                    "exp" => $time + (30 * 60),
                    "data" => [
                            'user'=> new UserDTO($user),
                        ]
                );
        return JWT::encode($token, $key);

    }

    public static function getData($token){

        try{

            $key = 'validaEmailDocument';

            $data =  JWT::decode($token, $key, array('HS256'))->data;
            return $data->user;


        }catch(\Exception $e){

            throw new Exception('La validaci&oacute;n no ha sido realizada exitosamente. Por favor int&eacute;ntelo nuevamente');
            

        }	

    }

}
?>
