<?php
declare(strict_types=1);
namespace src\application;

use src\EmailInterface;
use src\domain\exception\AuthException;
use src\domain\user\UserRepository;
use src\domain\user\User;

class RecoveryPassword{

    private $email;
    private $userRepository;
    private $userEmail;

	public function __construct(EmailInterface $email,UserRepository $userRepository, string $userEmail){

        if(filter_var($userEmail, FILTER_VALIDATE_EMAIL)){
            
            $this->email = $email;
            $this->userRepository = $userRepository;
            $this->userEmail = $userEmail;
        
        }else{

            throw new AuthException('Formato del email inv&aacute;lido'); 

        }

    }
    
    private function getNewPassword() : string {

        $key = '';
 		$pattern = '1234567890abcdefghijklmnopqrstuvwxyz';
 		$max = strlen($pattern)-1;
 		for($i=0;$i < 10;$i++){
			 $key .= $pattern{mt_rand(0,$max)};
		}
 		return $key;

    }

    private function changePassword(User $user, string $password) : bool {
        
        
        if($user->getType() == 2){
            $user->RecoveryPasswordProvider($password);
        }else{
             $user->RecoveryPassword($password);
        }
        return $this->userRepository->updatePassword($user);

    }
   
    public function execute(){

        try{

            $user = $this->userRepository->getUser('email',$this->userEmail);
            $password = $this->getNewPassword();

            if($this->changePassword($user,$password)){

    
                if($user->getType() == 2){
    
                    return $this->email->sendNewPasswordProvider( ucwords($user->getName()),$user->getEmail(), $password);
    
                }else{
                    
                    return $this->email->sendNewPassword($user->getEmail(), $password);
                    
                }

            }

            return false;

        }catch(\Exception $e){

            throw new \Exception($e->getMessage());

        }

    }

}
?>
