<?php
declare(strict_types=1);
namespace src\application;

use src\application\exception\UserInvalid;

class Authorization{

	public function __construct(){}

    /**
     * Verifica que el usuario ha iniciado sesion
     *
     * @return boolean
     */
    public function isLogin(): bool{

        return isset($_SESSION['autorizado_online']);

    }
    
    /**
     * Verifica que el o los tipos de usuarios sean validos para realizar la accion
     *
     * @param array $type tipos de usuarios que pueden realizar la accion 
     * @return boolean
     */
    public function isUserValid(array $type) : bool{

        try{

            return in_array($_SESSION['user_type'],$type);

        }catch(UserInvalid $e){

            return false;

        }


    }

    /**
     * Verifica si el usuario es un webmaster
     *
     * @return boolean
     */
    public function isWebmaster() : bool{

        return ($_SESSION["user_type"] == 1);

    }

    /**
     * Verifica si el usuario es uno quienes tienen acceso al administrador
     *
     * @return boolean
     */
    public function isAdmin() : bool{

        return ($_SESSION["user_type"] == 4 || $_SESSION["user_type"] == 5 || $_SESSION["user_type"] == 1);

    }

    /**
     * Verifica si el usuario es un provider
     *
     * @return boolean
     */
    public function isProvider() : bool{

        return ($_SESSION["user_type"] == 2);

    }

}
?>
