<?php
declare(strict_types=1);
namespace src\application;

use Exception;
use \Firebase\JWT\JWT;
use src\domain\user\UserDTO;
use src\domain\user\UserLogged;
use src\domain\user\UserRepository;

require_once $GLOBALS['app_root']."/src/utils/jwt/vendor/autoload.php";
use src\domain\event\LogEventPublisher;
use src\application\exception\UserInvalid;

class Authentication{

    private $email;
    private $password;
    private $UserRepository;
    private $token;

	public function __construct(string $email,string $password,UserRepository $UserRepository){

        if(filter_var($email, FILTER_VALIDATE_EMAIL)){
            
            $this->email = $email;
            $this->password = $password;
            $this->UserRepository = $UserRepository;
        
        }else{

            throw new Exception('Formato del email inv&aacute;lido'); 

        }
        

	}
   
    public function login(string $type){

        try{

            $user = $this->UserRepository->login($this->email,$this->password);
            $this->setSession($user);
            LogEventPublisher::instance()->publish(
                    new UserLogged($user->getId(),$type)
                );

        }catch(\Exception $e){

            throw new Exception($e->getMessage());

        }

    }

    private function setSession($user){

        $key = 'StoreOnline';
        $time = time();
        $token = array(
                    "iat" => $time,
                    "exp" => $time + (30 * 60 * 60),
                    "data" => [
                            'user'=> new UserDTO($user),
                        ]
                );
        $_SESSION['autorizado_online'] = true;
        $_SESSION['user_type'] = $user->getType();
        $_SESSION['user_token'] = JWT::encode($token, $key);

    }

    public static function getUserAuth(){

        try{

            $key = 'StoreOnline';

            $data =  JWT::decode($_SESSION['user_token'], $key, array('HS256'))->data;
            return $data->user;


        }catch(\Exception $e){

            Authentication::logOut();
            throw new UserInvalid();

        }	

    }

    private function checkSession(): bool{

        return $_SESSION['autorizado_online'];

    }
    
    public static function logOut(){

        unset($_SESSION['autorizado_online']);
        unset($_SESSION['user_token']);

    }

}
?>
