<?php

require_once "../configuracion/inicio.php";

$typeUserValid = array(1);

require_once "../configuracion/validar_sesion.php";

use src\utils\Paginator;
use src\application\log\LogList;
use src\application\user\UserGet;
use src\application\user\UserList;
use src\application\log\LogListRequest;
use src\application\user\UserGetRequest;
use src\application\user\UserListRequest;
use src\infrastructure\sql\SqlLogEventStore;
use src\infrastructure\sql\SqlUserRepository;

$logRepository = new SqlLogEventStore();
$userRepository = new SqlUserRepository();

$request = new UserListRequest(array('type'=>1),array());
$userList = new UserList($userRepository);
$result = $userList->execute($request);
$listUsers = $result['registers'];

$parametros = $section = $control = $fecha_inicio = $fecha_fin = $url = "";
$usuario = -1;
$variables = $opciones = array();
$page_size = 60;
$pg = 1;

if(isset($_GET["parametros"])){
	$variables = explode("/",$_GET["parametros"]);
	for($i = 0; $i < count($variables); $i+=2) {
		if($variables[$i] == "pg"){
			$pg = $variables[$i+1];
		}
		if($variables[$i] == "user"){
			$cliente = $variables[$i+1];
		}
		if($variables[$i] == "datebegin"){
			$fecha_inicio = $variables[$i+1];
		}
		if($variables[$i] == "dateend"){
			$fecha_fin = $variables[$i+1];
		}
		if($variables[$i] == "section"){
			$section = $variables[$i+1];
		}
	}
}

if(isset($_POST["datebegin"])){
	$fecha_inicio = $_POST["datebegin"];
}
if(isset($_POST["dateend"])){
	$fecha_fin = $_POST["dateend"];
}
if(isset($_POST["user"])){
	$usuario = $_POST["user"];
}
if(isset($_POST["section"])){
	$section = $_POST["section"];
}

if($usuario != -1){
	$opciones["user"] = $usuario;
	$parametros .= "/user/".$usuario;
}
if($fecha_inicio != ""){
	$opciones["date"] = date("Y-m-d",strtotime($fecha_inicio));
	$parametros .= "/datebegin/".$fecha_inicio;
}

if($fecha_fin != ""){
	$opciones["date"] = $opciones["date"].",".date("Y-m-d",strtotime($fecha_fin));
	$parametros .= "/dateend/".$fecha_fin;
}

if($section != ""){
	$opciones["section"] = $section;
	$url = "/section/".$section;
}


$pag = new Paginator(0,$page_size,$GLOBALS['domain_root'].'/manager/logs'.$url.$parametros,$pg);
$request = new LogListRequest($opciones,array($pag->start_record,$page_size));
$logList = new LogList($logRepository);
$result = $logList->execute($request);
$count = $result['total'];
$pag->records = $count;
$listado = json_decode($result['registers']);
$i = $pag->get_total_pages();

?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <?php require_once "../template/manager/head.php";?>
        <link href="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/plugins/bootstrap-datepicker/css/bootstrap-datepicker.min.css" rel="stylesheet">
    </head>
    <body>
		<?php
		require_once "../template/preloader.php";
		require_once "../template/manager/header.php";
		?>
        <div class="wrapper">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box">
                            <div class="btn-group pull-right">
                                <ol class="breadcrumb hide-phone p-0 m-0">
                                	<li>
                                        <a href="<?php echo $GLOBALS['domain_root']; ?>/manager/dashboard">Dashboard</a>
                                    </li>
                                    <li class="active">
                                        Logs
                                    </li>
                                </ol>
                            </div>
                            <h4 class="page-title">Logs</h4>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="card-box">
                            <div class="row">
                                  <div class="col-sm-12">
                                      <form role="form" method="post" action="<?php echo $GLOBALS['domain_root']; ?>/manager/logs<?php echo $url; ?>">
                                          <div class="form-group col-lg-4 col-md-4 col-sm-4 col-xs-12 selectpicker" data-style="btn-default btn-rounded">

                                                <select name="user" data-style="btn-default" class="form-control selectpicker" onChange="this.form.submit();">
                                                    <option value="-1" <?php if($usuario == -1){?> selected <?php } ?> >Usuarios...</option>
                                                    <?php
                                                    if(count($listUsers) > 0){
                                                        foreach($listUsers as $datos_user){
                                                    ?>
                                                    <option value="<?php echo $datos_user->id; ?>" <?php if($usuario == $datos_user->id){?> selected <?php } ?> ><?php echo $datos_user->name; ?></option>
                                                    <?php }
                                                    } ?>
                                                </select>
                                            </div>
                                            <div class="form-group col-lg-4 col-md-4 col-sm-4 col-xs-12">
                                                <div>
                                                    <div class="input-daterange input-group" id="date-range">
                                                        <input autocomplete="off" type="text" placeholder="Date" class="form-control" name="datebegin" value="<?php echo $fecha_inicio; ?>" />
                                                        <span class="input-group-addon bg-inverse text-white b-0">to</span>
                                                        <input autocomplete="off" type="text" placeholder="Date" class="form-control" name="dateend" value="<?php echo $fecha_fin; ?>" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group col-lg-4 col-md-4 col-sm-4 col-xs-12 button-list">

                                                <button type="submit" class="btn btn-success btn-rounded btn-md waves-effect waves-light m-b-30">Buscar</button>
                                                <button onClick="javascript:window.location='<?php echo $GLOBALS['domain_root']; ?>/manager/logs/section/<?php echo $section; ?>'" type="button" class="btn btn-default btn-rounded btn-md waves-effect waves-light m-b-30">Limpiar</button>
                                            </div>
                                      </form>
                                  </div>
                              </div>
                            <?php
                            if($count){?>
                            <div class="table-responsive">
                                <table class="tablesaw table m-0 table-colored table-inverse" data-tablesaw-mode="stack">
                                    <thead>
                                        <tr>
                                            <tr>
                                                <th>Usuario</th>
                                                <th>IP</th>
                                                <th>Navegador</th>
                                                <th>Acci&oacute;n</th>
                                                <th>Fecha</th>
                                            </tr>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        foreach($listado as $log){
                                            $requestUser = new UserGetRequest($log->user,'id');
                                            $getUser = new UserGet($userRepository);
                                            $user = $getUser->execute($requestUser);
                                        
                                        ?>
                                        <tr>
                                            <td><?php echo $user['user']->name; ?></td>
                                            <td><?php echo $log->ip; ?></td>
                                            <td><?php echo $log->browser; ?></td>
                                            <td><?php echo $log->action; ?></td>
                                            <td><?php echo $log->date; ?></td>
                                        </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                            <div class="text-right">
                                <ul class="pagination m-t-0">
                                    <?php echo $pag->print_paginator(); ?>
                                </ul>
                            </div>
                            <?php }else{ ?>
                            <h3 class="text-center">No Logs</h3>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div> <!-- container -->
        </div>

        <?php require_once "../template/manager/js.php";?>
        <script src="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/plugins/bootstrap-select/js/bootstrap-select.min.js" type="text/javascript"></script>
        <script src="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
        <script>
			$(document).ready(function(e) {
                $('.selectpicker').selectpicker();

				$('#date-range').datepicker({
					toggleActive: true,
					format: 'd-m-yyyy'
				});
			});
		</script>
    </body>
</html>
