<?php
require_once "../../configuracion/inicio.php";

$typeUserValid = array(1,4,5);

require_once "../../configuracion/validar_sesion.php";

use Exception;
use src\application\document\DocumentGet;
use src\application\category\CategoryList;
use src\application\provider\ProviderList;
use src\infrastructure\sql\SqlUserRepository;
use src\application\document\DocumentGetRequest;
use src\application\category\CategoryListRequest;
use src\infrastructure\sql\SqlCategoryRepository;
use src\infrastructure\sql\SqlDocumentRepository;

$documentRepository = new SqlDocumentRepository();
$categoryRepository = new SqlCategoryRepository();
$userRepository = new SqlUserRepository();

try{

    if($userLogin->type == 4){
    
        $typeUser = 2;
        $opcionesCategory['type'] = 1;
        
    }else if($userLogin->type == 5){
        
        $typeUser = 3;
        $opcionesCategory['type'] = 2;
    }

    $opcionesCategory['category.status'] = 1;

    $requestCategory = new CategoryListRequest($opcionesCategory,array());
    $categoryList = new CategoryList($categoryRepository);
    $categoryListResult = $categoryList->execute($requestCategory);

    $providerList = new ProviderList($userRepository);
    $providerListResult = $providerList->execute($requestProvider);
    
    $request = new DocumentGetRequest($_GET["id"],'id');
    $documentGet = new DocumentGet($documentRepository);
    $result = $documentGet->execute($request);
    $document = $result['document'];

}catch(Exception $e){
    
    header("location: ".$GLOBALS['domain_root']."/manager/files/dashboard");
    exit();

}
?>
<!DOCTYPE html>
<html>
    <head>
        <?php require_once "../../template/manager/head.php";?>
        <link href="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/plugins/bootstrap-datepicker/css/bootstrap-datepicker.min.css" rel="stylesheet">
    </head>
    <body>
		<?php
		require_once "../../template/preloader.php";
		require_once "../../template/manager/header.php";
		?>
        <div class="wrapper">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box">
                            <div class="btn-group pull-right">
                                <ol class="breadcrumb hide-phone p-0 m-0">
                                	<li>
                                        <a href="<?php echo $GLOBALS['domain_root']; ?>/manager/dashboard">Dashboard</a>
                                    </li>
                                    <li>
                                        <a href="<?php echo $GLOBALS['domain_root']; ?>/manager/files/dashboard">Documentos</a>
                                    </li>
                                    <li class="active">
                                        Editar Documento
                                    </li>
                                </ol>
                            </div>
                            <h4 class="page-title">Editar Documento <?php echo $document->name; ?></h4>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                    	<div id="msj"></div>
                    	<div class="card-box">
                            <form id="formFile" action="#" method="post">
                                <input type="hidden" name="id" value="<?php echo $document->id; ?>"/>
                                <input type="hidden" name="update-document" value="1"/>
                                <input type="hidden" name="empty" value="">
                                <div class="form-group p-b-10 p-t-10 col-md-6 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <label for="name">Nombre:&nbsp;<span class="text-danger">(*)</span>:</label>
                                    <input type="text" class="form-control" name="name" required value="<?php echo $document->name; ?>">
                                </div>
                                <div class="p-b-10 p-t-10 col-md-6">
                                    <div class="form-group clearfix">
                                        <label class="control-label" for="category">Categor&iacute;a &nbsp;<span class="text-danger">(*)</span>: </label>
                                        <select data-live-search="true" data-style="btn-default" class="form-control selectpicker" name="category">
                                            <option value="">Seleccione...</option>
                                            <?php if($categoryListResult['total']){
                                                foreach($categoryListResult['registers'] as $categoryDetail){
                                            ?>
                                            <option <?php echo ($document->idCategory == $categoryDetail->id ) ? 'selected' : ''; ?> value="<?php echo $categoryDetail->id; ?>"><?php echo $categoryDetail->name; ?></option>
                                            <?php
                                                }
                                            } ?>
                                        </select>
                                    </div>
                                </div>
                                <?php if($typeUser == 0){ ?>
                                <div class="p-b-10 p-t-10 col-md-6">
                                    <div class="form-group clearfix">
                                        <label class="control-label" for="type_user">Visualizado por: </label>
                                        <select id="type_user" data-style="btn-default" class="form-control selectpicker" name="type_user">
                                            <option value="" <?php echo ( $document->typeUser == 0 ) ? 'selected' : ''; ?>>Seleccione...</option>
                                            <option value="2" <?php echo ( $document->typeUser == 2 ) ? 'selected' : ''; ?>>Proveedores</option>
                                            <option value="3" <?php echo ( $document->typeUser == 3 ) ? 'selected' : ''; ?>>Clientes</option>
                                        </select>
                                    </div>
                                    <p class="help-block">Si no selecciona ning&uacute;n, el documento es visualizado por todos</p>
                                </div>
                                <?php }else{ ?>
                                <input type="hidden" name="type_user" value="<?php echo $typeUser; ?>">
                                <?php } ?>
                                <div style="max-height:64px;" class="form-group p-b-10 p-t-10 col-md-6 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <label for="image">Archivo&nbsp;<span class="text-danger">(*)</span>:</label>
                                    <input type="file" name="file" class="filestyle" data-placeholder="No file"/>
                                    <p class="help-block"><a target="_blank" href="<?php echo $GLOBALS['domain_root']; ?>/file/<?php echo $document->file; ?>">Ver Archivo</a></p>
                                </div>
                                <div class="p-b-10 p-t-10 col-md-6">
                                    <div class="form-group clearfix">
                                        <label class="control-label" for="provider">Proveedor / Cliente: </label>
                                        <select data-live-search="true" multiple data-style="btn-default" class="form-control selectpicker" id="provider" name="provider[]">
                                            <option value="">Seleccione...</option>
                                            <?php if($providerListResult['total']){
                                                foreach($providerListResult['registers'] as $providerDetail){
                                                    $show = true;
                                                    $type = 'Cliente';
                                                    if($providerDetail->type == 2){
                                                        $type = 'Proveedor';
                                                    }
                                                    if(($typeUser != 0) &&($typeUser != $providerDetail->type)){
                                                        $show = false;
                                                    }
                                                    if($show){
                                            ?>
                                            <option data-type="<?php echo $providerDetail->type; ?>" <?php echo in_array($providerDetail->id,$document->provider ) ? 'selected' : ''; ?> value="<?php echo $providerDetail->id; ?>"><?php echo $type.' : '.$providerDetail->name; ?></option>
                                            <?php 
                                                    }
                                                }
                                            } ?>
                                        </select>
                                    </div>
                                    <p class="help-block">Si no selecciona ning&uacute;n proveedor, el documento es visualizado por todos</p>
                                </div>
                                <div class="form-group p-b-10 p-t-10 col-md-6 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <label for="date">Fecha:&nbsp;<span class="text-danger">(*)</span>:</label>
                                    <input type="text" id="date" value="<?php echo $document->date; ?>" class="form-control" name="date" required>
                                </div>
                                <div class="clearfix"></div>
                                <div class="text-center">
                                    <button type="submit" class="btn btn-success waves-effect waves-light">Guardar</button>
                                    <button onClick="javascript:window.location='<?php echo $GLOBALS['domain_root']; ?>/manager/files/dashboard'" type="button" class="btn btn-danger waves-effect waves-light">Cancelar</button>
                                    <h2 class="hide wait-form text-center"><i class="fa fa-refresh fa-spin text-green"></i></h2>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <?php require_once "../../template/manager/footer.php";?>
            </div>
        </div>
        <?php require_once "../../template/manager/js.php";?>
        <script src="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js" type="text/javascript"></script>
        <script src="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/plugins/bootstrap-select/js/bootstrap-select.min.js" type="text/javascript"></script>
        <script src="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
        <script type="text/javascript" src="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/js/pages/file.js"></script>
    </body>
</html>
