<?php
require_once "../../configuracion/inicio.php";

use src\application\category\CategoryList;
use src\application\provider\ProviderList;
use src\infrastructure\sql\SqlUserRepository;
use src\application\category\CategoryListRequest;
use src\infrastructure\sql\SqlCategoryRepository;

$typeUserValid = array(1,4,5);

require_once "../../configuracion/validar_sesion.php";

$categoryRepository = new SqlCategoryRepository();
$userRepository = new SqlUserRepository();
$typeUser = 0;

if($userLogin->type == 4){
    
    $typeUser = 2;
    $opcionesCategory['type'] = 1;
    
}else if($userLogin->type == 5){
    
    $typeUser = 3;
    $opcionesCategory['type'] = 2;
}

$opcionesCategory['category.status'] = 1;

$requestCategory = new CategoryListRequest($opcionesCategory,array());
$categoryList = new CategoryList($categoryRepository);
$categoryListResult = $categoryList->execute($requestCategory);

$providerList = new ProviderList($userRepository);
$providerListResult = $providerList->execute();


?>
<!DOCTYPE html>
<html>
    <head>
        <?php require_once "../../template/manager/head.php";?>
        <link href="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/plugins/bootstrap-datepicker/css/bootstrap-datepicker.min.css" rel="stylesheet">
    </head>
    <body>
		<?php
		require_once "../../template/preloader.php";
		require_once "../../template/manager/header.php";
		?>
        <div class="wrapper">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box">
                            <div class="btn-group pull-right">
                                <ol class="breadcrumb hide-phone p-0 m-0">
                                	<li>
                                        <a href="<?php echo $GLOBALS['domain_root']; ?>/manager/dashboard">Dashboard</a>
                                    </li>
                                    <li>
                                        <a href="<?php echo $GLOBALS['domain_root']; ?>/manager/files/dashboard">Documentos</a>
                                    </li>
                                    <li class="active">
                                        Agregar Documento
                                    </li>
                                </ol>
                            </div>
                            <h4 class="page-title">Agregar Documento</h4>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                    	<div id="msj"></div>
                    	<div class="card-box">
                            <form id="formFile" action="#" method="post">
                                <input type="hidden" name="empty"/>
                                <input type="hidden" name="create-document" value="1"/>
                                <input type="hidden" name="empty" value="">
                                <div class="form-group p-b-10 p-t-10 col-md-6 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <label for="name">Nombre:&nbsp;<span class="text-danger">(*)</span>:</label>
                                    <input type="text" class="form-control" name="name" required>
                                </div>
                                <div class="p-b-10 p-t-10 col-md-6">
                                    <div class="form-group clearfix">
                                        <label class="control-label" for="category">Categor&iacute;a &nbsp;<span class="text-danger">(*)</span>: </label>
                                        <select data-live-search="true" required data-style="btn-default" class="form-control selectpicker" name="category">
                                            <option value="">Seleccione...</option>
                                            <?php if($categoryListResult['total']){
                                                foreach($categoryListResult['registers'] as $categoryDetail){
                                            ?>
                                            <option value="<?php echo $categoryDetail->id; ?>"><?php echo $categoryDetail->name; ?></option>
                                            <?php
                                                }
                                            } ?>
                                        </select>
                                    </div>
                                </div>
                                <?php if($typeUser == 0){ ?>
                                <div class="p-b-10 p-t-10 col-md-6">
                                    <div class="form-group clearfix">
                                        <label class="control-label" for="type_user">Visualizado por: </label>
                                        <select id="type_user" data-style="btn-default" class="form-control selectpicker" name="type_user">
                                            <option value="">Seleccione...</option>
                                            <option value="2">Proveedores</option>
                                            <option value="3">Clientes</option>
                                        </select>
                                    </div>
                                    <p class="help-block">Si no selecciona ning&uacute;n, el documento es visualizado por todos</p>
                                </div>
                                <?php }else{ ?>
                                <input type="hidden" name="type_user" value="<?php echo $typeUser; ?>">
                                <?php } ?>
                                <div class="form-group p-b-10 p-t-10 col-md-6 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <label for="image">Archivo&nbsp;<span class="text-danger">(*)</span>:</label>
                                    <input required type="file" name="file" class="filestyle" data-placeholder="No file"/>
                                </div>
                                <div class="p-b-10 p-t-10 col-md-6">
                                    <div class="form-group clearfix">
                                        <label class="control-label" for="provider">Proveedor / Cliente: </label>
                                        <select data-live-search="true" multiple data-style="btn-default" class="form-control selectpicker" id="provider" name="provider[]">
                                            <option value="">Seleccione...</option>
                                            <?php if($providerListResult['total']){
                                                foreach($providerListResult['registers'] as $providerDetail){
                                                    $show = true;
                                                    $type = 'Cliente';
                                                    if($providerDetail->type == 2){
                                                        $type = 'Proveedor';
                                                    }
                                                    if(($typeUser != 0) &&($typeUser != $providerDetail->type)){
                                                        $show = false;
                                                    }
                                                    if($show){
                                            ?>
                                            <option data-type="<?php echo $providerDetail->type; ?>" value="<?php echo $providerDetail->id; ?>"><?php echo $type.' : '.$providerDetail->name; ?></option>
                                            <?php
                                                    }
                                                }
                                            } ?>
                                        </select>
                                    </div>
                                    <p class="help-block">Si no selecciona ning&uacute;n, el documento es visualizado por todos</p>
                                </div>
                                <div class="form-group p-b-10 p-t-10 col-md-6 col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <label for="date">Fecha:&nbsp;<span class="text-danger">(*)</span>:</label>
                                    <input type="text" autocomplete="off" id="date" class="form-control" name="date" required>
                                </div>
                                <div class="clearfix"></div>
                                <div class="text-center">
                                    <button type="submit" class="btn btn-success waves-effect waves-light">Guardar</button>
                                    <button onClick="javascript:window.location='<?php echo $GLOBALS['domain_root']; ?>/manager/files/dashboard'" type="button" class="btn btn-danger waves-effect waves-light">Cancelar</button>
                                    <h2 class="hide wait-form text-center"><i class="fa fa-refresh fa-spin text-green"></i></h2>
                            </form>
                        </div>
                    </div>
                </div>
                <?php require_once "../../template/manager/footer.php";?>
            </div>
        </div>
		<?php require_once "../../template/manager/js.php";?>
        <script src="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/plugins/bootstrap-filestyle/js/bootstrap-filestyle.min.js" type="text/javascript"></script>
        <script src="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/plugins/bootstrap-select/js/bootstrap-select.min.js" type="text/javascript"></script>
        <script src="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
        <script type="text/javascript" src="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/js/pages/file.js"></script>
    </body>
</html>
