<?php
require_once "../configuracion/inicio.php";

$typeUserValid = array(1,4,5);

require_once "../configuracion/validar_sesion.php";

use Exception;
use src\utils\Paginator;
use src\application\log\LogList;
use src\application\user\UserGet;
use src\application\user\UserList;
use src\application\log\LogListRequest;
use src\application\user\UserGetRequest;
use src\application\provider\ProviderGet;
use src\application\user\UserListRequest;
use src\infrastructure\sql\SqlLogEventStore;
use src\infrastructure\sql\SqlUserRepository;
use src\application\provider\ProviderGetRequest;

$logRepository = new SqlLogEventStore();
$userRepository = new SqlUserRepository();

$request = new LogListRequest(array('section'=>'user'),array(0,60));
$logList = new LogList($logRepository);
$result = $logList->execute($request);
$countLogs = $result['total'];
$listadoLogs = json_decode($result['registers']);
$opcionesValid = array('valid'=>1);
$opcionesInvalid = array('valid'=>0);
$opcionesActive = array('status'=>1);
$opcionesInactive = array('status'=>0);

if($userLogin->type == 4){
    
    $opcionesValid['type'] = 2;
    $opcionesInvalid['type'] = 2;
    $opcionesActive['type'] = 2;
    $opcionesInactive['type'] = 2;
    
}else if($userLogin->type == 5){
    
    $opcionesValid['type'] = 3;
    $opcionesInvalid['type'] = 3;
    $opcionesActive['type'] = 3;
    $opcionesInactive['type'] = 3;
}

$request = new UserListRequest($opcionesValid,array());
$listResult = new UserList($userRepository);
$listResult = $listResult->execute($request); 
$totalValid = $listResult['total'];
$listValid = $listResult['registers'];

$request = new UserListRequest($opcionesInvalid,array());
$listResult = new UserList($userRepository);
$listResult = $listResult->execute($request);
$totalNoValid = $listResult['total'];

$request = new UserListRequest($opcionesActive,array());
$listResult = new UserList($userRepository);
$listResult = $listResult->execute($request);
$totalActive = $listResult['total'];

$request = new UserListRequest($opcionesInactive,array());
$listResult = new UserList($userRepository);
$listResult = $listResult->execute($request);
$totalNoActive = $listResult['total'];

?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <?php require_once "../template/manager/head.php";?>
        <link rel="stylesheet" href="https://cdn.datatables.net/1.10.22/css/jquery.dataTables.min.css">
        <link rel="stylesheet" href="https://cdn.datatables.net/1.10.22/css/dataTables.bootstrap.min.css">
        <style>
            div.dataTables_wrapper div.dataTables_filter input{ width:auto !important;}
        </style>
    </head>
    <body>
		<?php
		require_once "../template/preloader.php";
		require_once "../template/manager/header.php";
		?>
        <div class="wrapper">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box">
                            <h4 class="page-title">Dashboard</h4>
                        </div>
                    </div>
                </div>
                <div class="row m-t-20">
                    <div class="col-md-6">
                        <div class="card-box">
                            <div id="idgraphicactive"></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card-box">
                            <div id="idgraphicvalid"></div>
                        </div>
                    </div>
                    <div class="col-md-6"></div>    
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="card-box">
                            <h3 class="header-title m-t-0">Emails Validados</h3>
                            <?php if($totalValid){?>
                            <div class="table-responsive">
                                <table id="providervalid" class="table table table-hover m-0" data-tablesaw-mode="stack">
                                    <thead>
                                        <tr>
                                            <th>Nombre</th>
                                            <th>C.I</th>
                                            <th>Email</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        foreach($listValid as $register){ 
                                            $requestUser = new ProviderGetRequest($register->id,'id');
                                            $getUser = new ProviderGet($userRepository);
                                            $user = $getUser->execute($requestUser);
                                        ?>
                                        <tr>
                                            <td><?php echo $user['provider']->name; ?></td>
                                            <td><?php echo $user['provider']->ci; ?></td>
                                            <td><?php echo $user['provider']->email; ?></td>
                                        </tr>
                                        <?php  } ?>
                                    </tbody>
                                </table>
                            </div>
                            <?php }else{ ?>
                            <h3 class="text-center">No hay registros</h3>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="card-box">
                            <h3 class="header-title m-t-0">Actividad</h3>
                            <?php if($countLogs){?>
                            <div class="table-responsive">
                                <table class="table table table-hover m-0" data-tablesaw-mode="stack">
                                    <thead>
                                        <tr>
                                            <th>Nombre</th>
                                            <th>Browser</th>
                                            <th>IP</th>
                                            <th>Acci&oacute;n</th>
                                            <th>Fecha</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        foreach($listadoLogs as $log){
                                            try{

                                                $requestUser = new UserGetRequest($log->user,'id');
                                                $getUser = new UserGet($userRepository);
                                                $user = $getUser->execute($requestUser);
                                                $name = $user['user']->name;

                                            ?>
                                            <tr>
                                                <td><?php echo $name; ?></td>
                                                <td><?php echo $log->browser; ?></td>
                                                <td><?php echo $log->ip; ?></td>
                                                <td><?php echo $log->action; ?></td>
                                                <td><?php echo $log->date; ?></td>
                                            </tr>
                                            <?php     
                                            }catch(Exception $e){}
                                        
                                        } ?>
                                    </tbody>
                                </table>
                            </div>
                            <?php }else{ ?>
                            <h3 class="text-center">No hay registros</h3>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <?php require_once "../template/manager/footer.php";?>
            </div>
        </div>
        <?php require_once "../template/manager/js.php";?>
        <script src="https://code.highcharts.com/highcharts.js"></script>
        <script src="https://code.highcharts.com/modules/exporting.js"></script>
        <script src="https://code.highcharts.com/modules/export-data.js"></script>
        <script src="https://code.highcharts.com/modules/accessibility.js"></script>
        <script src="https://cdn.datatables.net/1.10.22/js/jquery.dataTables.min.js"></script>
        <script src="https://cdn.datatables.net/1.10.22/js/dataTables.bootstrap.min.js"></script>
        <script>
            $('#providervalid').DataTable({
								'searching':true,
								'destroy':true,
								"language": {
									"lengthMenu": "_MENU_ registros",
                                    "info": "_PAGE_ de _PAGES_",
                                    "search":"Buscar",
									"paginate": {
										"first":"<<",
										"last": ">>",
										"next": ">",
										"previous": "<"
									},
								}
							});
            Highcharts.chart('idgraphicactive', {
                chart: {
                    plotBackgroundColor: null,
                    plotBorderWidth: null,
                    plotShadow: false,
                    type: 'pie'
                },
                title: {
                    text: 'Activos'
                },
                tooltip: {
                    pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
                },
                accessibility: {
                    point: {
                        valueSuffix: '%'
                    }
                },
                plotOptions: {
                    pie: {
                        allowPointSelect: true,
                        cursor: 'pointer',
                        dataLabels: {
                            enabled: true,
                            format: '<b>{point.name}</b>: {point.percentage:.1f} %'
                        }
                    }
                },
                series: [{
                    name: 'Total',
                    colorByPoint: true,
                    data: [{
                        name: 'Activos',
                        y: <?php echo $totalActive; ?>
                    }, {
                        name: 'No Activos',
                        y: <?php echo $totalNoActive; ?>
                    }]
                }]
            });

            Highcharts.chart('idgraphicvalid', {
                chart: {
                    plotBackgroundColor: null,
                    plotBorderWidth: null,
                    plotShadow: false,
                    type: 'pie'
                },
                title: {
                    text: 'Válidados'
                },
                tooltip: {
                    pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
                },
                accessibility: {
                    point: {
                        valueSuffix: '%'
                    }
                },
                plotOptions: {
                    pie: {
                        allowPointSelect: true,
                        cursor: 'pointer',
                        dataLabels: {
                            enabled: true,
                            format: '<b>{point.name}</b>: {point.percentage:.1f} %'
                        }
                    }
                },
                series: [{
                    name: 'Total',
                    colorByPoint: true,
                    data: [{
                        name: 'Válidados',
                        y: <?php echo $totalValid; ?>
                    }, {
                        name: 'No Válidados',
                        y: <?php echo $totalNoValid; ?>
                    }]
                }]
            });
        </script>
    </body>
</html>
