<?php
require_once "../../configuracion/inicio.php";

$typeUserValid = array(1,5);

require_once "../../configuracion/validar_sesion.php";

use src\utils\Paginator;
use src\application\user\UserList;
use src\application\user\UserListRequest;
use src\infrastructure\sql\SqlUserRepository;

$userRepository = new SqlUserRepository();
$parametros = $msj = $nombre = $ci = "";
$variables = array();
$opciones = array('type'=>3);
$page_size = 40;
$pg = 0;

if(isset($_GET["parametros"])){
	$variables = explode("/",$_GET["parametros"]);
	for($i = 0; $i < count($variables); $i+=2) {
		if($variables[$i] == "pg"){
			$pg = $variables[$i+1];
		}
		if($variables[$i] == "search"){
			$nombre = $variables[$i+1];
        }
		if($variables[$i] == "ci"){
			$ci = $variables[$i+1];
        }
		if($variables[$i] == "msj"){
			$msj = $variables[$i+1];
		}
	}
}

if(isset($_POST["search"])){
	$nombre = $_POST["search"];
}
if(isset($_POST["ci"])){
	$ci = $_POST["ci"];
}

if($nombre != ""){
	$opciones["name"] = $nombre;
	$parametros .= "/search/".$nombre;
}

if($ci != ""){
	$opciones["ci"] = $ci;
	$parametros .= "/ci/".$ci;
}


$pag = new Paginator(0,$page_size,$GLOBALS['domain_root'].'/manager/client/dashboard'.$parametros,$pg);
$request = new UserListRequest($opciones,array($pag->start_record,$page_size));
$userList = new UserList($userRepository);
$result = $userList->execute($request);
$count = $result['total'];
$pag->records = $count;
$listado = $result['registers'];
$i = $pag->get_total_pages();

?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <?php require_once "../../template/manager/head.php";?>
    </head>
    <body>
		<?php
		require_once "../../template/preloader.php";
		require_once "../../template/manager/header.php";
		?>
        <div class="wrapper">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box">
                            <h1 class="page-title">Clientes</h1>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                    	<div class="card-box">
                            <div class="row">
                                <div class="col-sm-12 text-right">
                                    <form role="form" method="post" action="<?php echo $GLOBALS['domain_root']; ?>/manager/client/dashboard/">
                                        <div class="form-group search-box col-lg-4 col-md-4 col-sm-4 col-xs-12">
                                            <input type="text" name="search" id="search-input" class="form-control product-search" placeholder="Nombre del Cliente" value="<?php echo $nombre; ?>">
                                            <button type="submit" class="btn btn-search"><i class="fa fa-search"></i></button>
                                        </div>
                                        <div class="form-group search-box col-lg-4 col-md-4 col-sm-4 col-xs-12">
                                            <input type="text" name="ci" class="form-control product-search" placeholder="C.I / RIF del Cliente" value="<?php echo $ci; ?>">
                                        </div>
                                    </form>
                                    <a href="<?php echo $GLOBALS['domain_root']; ?>/manager/client/add" class="btn btn-success btn-rounded btn-md waves-effect waves-light m-b-30"><i class="fa fa-plus"></i> Nuevo</a>
                                    <a href="<?php echo $GLOBALS['domain_root']; ?>/manager/client/import" class="btn btn-success btn-rounded btn-md waves-effect waves-light m-b-30"><i class="fa fa-upload"></i> Importar</a>
                                </div>
                            </div>
                            <?php if($msj != ""){ ?>
                          	<div class="alert alert-icon alert-success alert-dismissible fade in" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">X</span>
                                </button>
                                <i class="mdi mdi-check-all"></i>
                                <?php if($msj == "inserted"){?>
                                <strong>Registro guardado exitosamente</strong>
                                <?php }
                                      if($msj == "updated"){
                                ?>
                                <strong>Registro guardado exitosamente</strong>
                                <?php }
                                      if($msj == "deleted"){
                                ?>
                                <strong>Registro eliminado exitosamente</strong>
                                <?php } ?>
                            </div>
                            <?php
                            }
                            if($count>0){?>
                            <div class="table-responsive">
                                <table id="tableRecord" class="tablesaw table m-0 table-colored table-inverse" data-tablesaw-mode="stack">
                                    <thead>
                                        <tr>
                                            <tr>
                                                <th>Nombre</th>
                                                <th>Email</th>
                                                <th>Email V&aacute;lidado</th>
                                                <th>Estado</th>
                                                <th>Opciones</th>
                                            </tr>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        foreach($listado as $registro){
                                        ?>
                                        <tr id="user<?php echo $registro->id; ?>">
                                            <td id="name"><?php echo $registro->name; ?></td>
                                            <td><?php echo $registro->email; ?></td>
                                            <td>
                                                <div class="form-group text-center">
                                                    <div class="checkbox checkbox-primary">
                                                        <input  <?php echo ($registro->valid == 1) ? 'checked' : ''; ?>  disabled id="valid" type="checkbox">
                                                        <label for="valid">
                                                        </label>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <input class="change-state" data-id="<?php echo $registro->id; ?>" type="checkbox" <?php echo ($registro->status == 1) ? 'checked' : ''; ?> data-plugin="switchery"  data-size="small" switch="success"  />
                                            </td>
                                            <td class="text-left">

                                                <a href="<?php echo $GLOBALS['domain_root']; ?>/manager/client/edit/<?php echo $registro->id; ?>" class="btn btn-sm btn-bordered waves-effect waves-light btn-primary"><i class="fa fa-edit"></i>&nbsp;Editar</a>
                                                <a data-id=<?php echo $registro->id; ?> class="<?php if($registro->status == 1) echo "hide"; ?> deleteRecord btn btn-sm btn-bordered waves-effect waves-light btn-danger"><i class="fa fa-trash"></i>&nbsp;Eliminar</a>
                                            </td>
                                        </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                            <div class="text-right">
                                <ul class="pagination m-t-0">
                                    <?php echo $pag->print_paginator(); ?>
                                </ul>
                            </div>
                            <?php }else{ ?>
                            <h3 class="text-center">No hay Registros</h3>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <?php require_once "../../template/manager/footer.php";?> 
            </div>
        </div>
        <?php require_once "../../template/manager/js.php";?>
        <script src="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/js/pages/provider.js" type="text/javascript"></script>
    </body>
</html>
