<?php
require_once "../../configuracion/inicio.php";

$typeUserValid = array(1,4,5);

require_once "../../configuracion/validar_sesion.php";

use src\utils\Paginator;
use src\application\category\CategoryList;
use src\application\category\CategoryListRequest;
use src\infrastructure\sql\SqlCategoryRepository;

$categoryRepository = new SqlCategoryRepository();
$parametros = $msj = $nombre = "";
$status = -1;
$variables = $opciones = array();
$page_size = 40;
$pg = 0;


if(isset($_GET["parametros"])){
	$variables = explode("/",$_GET["parametros"]);
	for($i = 0; $i < count($variables); $i+=2) {
		if($variables[$i] == "pg"){
			$pg = $variables[$i+1];
		}
		if($variables[$i] == "search"){
			$nombre = $variables[$i+1];
		}
		if($variables[$i] == "status"){
			$status = $variables[$i+1];
		}
		if($variables[$i] == "msj"){
			$msj = $variables[$i+1];
		}
	}
}

if(isset($_POST["search"])){
	$nombre = $_POST["search"];
}
if(isset($_POST["status"])){
	$status = $_POST["status"];
}
if($nombre != ""){
	$opciones["category.name"] = $nombre;
	$parametros .= "/search/".$nombre;
}
if($status != -1){
	$opciones["category.status"] = $status;
	$parametros .= "/status/".$status;
}

if($userLogin->type == 4){
    
    $opciones['type'] = 1;

}else if($userLogin->type == 5){
    
    $opciones['type'] = 2;

}

$pag = new Paginator(0,$page_size,$GLOBALS['domain_root'].'/manager/categories/dashboard'.$parametros,$pg);
$request = new CategoryListRequest($opciones,array($pag->start_record,$page_size));
$categoryList = new CategoryList($categoryRepository);
$result = $categoryList->execute($request);
$count = $result['total'];
$pag->records = $count;
$listado = $result['registers'];
$i = $pag->get_total_pages();
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <?php require_once "../../template/manager/head.php";?>
    </head>
    <body>
		<?php
		require_once "../../template/preloader.php";
		require_once "../../template/manager/header.php";
		?>
        <div class="wrapper">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box">
                            <h1 class="page-title">Categorias</h1>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                    	<div class="card-box">
                            <div class="row">
                                <div class="col-sm-12 text-right">
                                    <form role="form" method="post" action="<?php echo $GLOBALS['domain_root']; ?>/manager/categories/dashboard/">
                                        <div class="form-group search-box col-lg-4 col-md-4 col-sm-4 col-xs-12">
                                            <input type="text" name="search" id="search-input" class="form-control product-search" placeholder="Nombre" value="<?php echo $nombre; ?>">
                                            <button type="submit" class="btn btn-search"><i class="fa fa-search"></i></button>
                                        </div>
										<div class="form-group search-box col-lg-4 col-md-4 col-sm-4 col-xs-12">
                                            <select data-style="btn-default" class="form-control selectpicker" onChange="this.form.submit();" name="status">
                                                <option value="-1">Estado</option>
                                                <option <?php echo (1 == $status) ? 'selected' : ''; ?> value="1">Activado</option>
                                                <option <?php echo (0 == $status) ? 'selected' : ''; ?> value="1">Desactivado</option>
                                            </select>
                                        </div>
                                    </form>
									<div class="clearfix"></div>
									<p class="text-right">
										<a href="<?php echo $GLOBALS['domain_root']; ?>/manager/categories/add" class="btn btn-success btn-rounded btn-md waves-effect waves-light m-b-30"><i class="fa fa-plus"></i> Nuevo</a>
									</p>
                                </div>
                            </div>
                            <?php if($msj != ""){ ?>
                          	<div class="alert alert-icon alert-success alert-dismissible fade in" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">X</span>
                                </button>
                                <i class="mdi mdi-check-all"></i>
                                <?php if($msj == "inserted"){?>
                                <strong>Registro guardado exitosamente</strong>
                                <?php }
                                      if($msj == "updated"){
                                ?>
                                <strong>Registro guardado exitosamente</strong>
                                <?php }
                                      if($msj == "deleted"){
                                ?>
                                <strong>Registro eliminado exitosamente</strong>
                                <?php } ?>
                            </div>
                            <?php
                            }
                            if($count>0){?>
							<div class="table-responsive" id="nestable" data-start="<?php echo $pag->start_record; ?>">

								<table class="table table-hover table-colored table-inverse m-0 table table-actions-bar">
									<thead>
										<tr>
											<th>Nombre</th>
											<th>Estado</th>
											<th>Opciones</th>
										</tr>
									</thead>
									<tbody>
										<?php
										foreach($listado as $registro){
											$checked = "checked";
											if($registro->status == 0){
												$checked = "";
											}
										?>
										<tr class="dd-item" data-id="<?php echo $registro->id; ?>" id="category<?php echo $registro->id; ?>">
											<td class="name">
												<?php echo $registro->name; ?>
											</td>
											<td>
												<input class="change-state" data-id=<?php echo $registro->id; ?> type="checkbox" <?php echo $checked; ?> data-plugin="switchery"  data-size="small" switch="success"  />
											</td>
											<td class="text-left">

												<a href="<?php echo $GLOBALS['domain_root']; ?>/manager/categories/edit/<?php echo $registro->id; ?>" class="btn btn-sm btn-bordered waves-effect waves-light btn-primary"><i class="fa fa-edit"></i>&nbsp;Editar</a>

												<a data-id="<?php echo $registro->id; ?>" class="<?php if($registro->status == 1) echo 'hide'; ?> deleteRecord btn btn-sm btn-bordered waves-effect waves-light btn-danger"><i class="fa fa-trash"></i>&nbsp;Eliminar</a>

											</td>
										</tr>
										<?php  } ?>
									</tbody>
								</table>
							</div>
                            <div class="text-right">
                                <ul class="pagination m-t-0">
                                    <?php echo $pag->print_paginator(); ?>
                                </ul>
                            </div>
                            <?php }else{ ?>
                            <h3 class="text-center">No hay registros</h3>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <?php require_once "../../template/manager/footer.php";?>
            </div>
        </div>
        <?php require_once "../../template/manager/js.php";?>
        <script src="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/js/pages/category.js" type="text/javascript"></script>
    </body>
</html>
