<?php
require_once "configuracion/inicio.php";

$typeUserValid = array(2,3);

require_once "configuracion/validar_sesion.php";

use Exception;
use src\utils\Paginator;
use src\application\category\CategoryGet;
use src\application\category\CategoryList;
use src\application\document\DocumentList;
use src\infrastructure\sql\SqlUserRepository;
use src\application\category\CategoryGetRequest;
use src\application\category\CategoryListRequest;
use src\application\document\DocumentListRequest;
use src\infrastructure\sql\SqlCategoryRepository;
use src\infrastructure\sql\SqlDocumentRepository;

$categoryRepository = new SqlCategoryRepository();
$documentRepository = new SqlDocumentRepository();
$userRepository = new SqlUserRepository();
$variables = $opciones = array();
$fecha_fin = $fecha_inicio = $nombre = '';
$page_size = 21;
$pg = 1;

try{

    if(isset($_GET["parametros"])){
        $variables = explode("/",$_GET["parametros"]);
        for($i = 0; $i < count($variables); $i+=2) {
            if($variables[$i] == "pg"){
                $pg = $variables[$i+1];
            }
            if($variables[$i] == "search"){
                $nombre = $variables[$i+1];
            }
            if($variables[$i] == "datebegin"){
                $fecha_inicio = $variables[$i+1];
            }
            if($variables[$i] == "dateend"){
                $fecha_fin = $variables[$i+1];
            }
        }
    }

    if(isset($_POST["search"])){
        $nombre = $_POST["search"];
    }

    if(isset($_POST["datebegin"])){
        $fecha_inicio = $_POST["datebegin"];
    }
    if(isset($_POST["dateend"])){
        $fecha_fin = $_POST["dateend"];
    }
    
    if($nombre != ""){
        $opciones["file.name"] = $nombre;
        $parametros .= "/search/".$nombre;
    }
    if($fecha_inicio != ""){
        $opciones["file.date"] = date("Y-m-d",strtotime($fecha_inicio));
        $parametros .= "/datebegin/".$fecha_inicio;
    }
    
    if($fecha_fin != ""){
        $opciones["file.date"] = $opciones["file.date"].",".date("Y-m-d",strtotime($fecha_fin));
        $parametros .= "/dateend/".$fecha_fin;
    }

    $request = new CategoryGetRequest($_GET["category"],'id');
    $categoryGet = new CategoryGet($categoryRepository);
    $result = $categoryGet->execute($request);
    $category = $result['category'];

    $opciones['file.category'] = $category->id;
    $opciones['file.status'] = 1;
    $opciones['file_provider.provider'] = $userLogin->id;
    $opciones['file.type_user'] = $userLogin->type;

    $pag = new Paginator(0,$page_size,$GLOBALS['domain_root'].'/document/'.$category->id.'/search'.$parametros,$pg);
    $request = new DocumentListRequest($opciones,array($pag->start_record,$page_size));
    $DocumentList = new DocumentList($documentRepository);
    $result = $DocumentList->execute($request);
    $count = $result['total'];
    $documents = $result['registers'];
    $pag->records = $count;
    $i = $pag->get_total_pages();

    $request = new CategoryListRequest(array('status'=>1),array());
    $categoryList = new CategoryList($categoryRepository);
    $categories = $categoryList->execute($request);

}catch(Exception $e){
    
    header("location: ".$GLOBALS['domain_root']."/dashboard");
    exit();

}
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <?php require_once "template/manager/head.php";?>
        <link href="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/plugins/bootstrap-datepicker/css/bootstrap-datepicker.min.css" rel="stylesheet">
    </head>
    <body>
		<?php
		require_once "template/preloader.php";
		require_once "template/header.php";
		?>
        <div class="wrapper">
            <div class="container m-t-40">
                <div class="row text-center">
                    <div class="col-lg-9 col-md-6 col-xs-12">
                        <div class="col-sm-12">
                            <div class="btn-group pull-right">
                                <ol class="breadcrumb p-0 m-0">
                                    <li>
                                        <a href="<?php echo $GLOBALS['domain_root']; ?>/dashboard">Dashboard</a>
                                    </li>
                                    <li class="active">
                                        Archivos
                                    </li>
                                </ol>
                            </div>
                            <div class="clearfix"></div>
                            <div class="page-title-box m-t-20" >
                                <h4 class="page-title">Archivos de <?php echo $category->name; ?></h4>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <div class="card-box">
                            <div class="row">
                                <div class="col-sm-12">
                                    <form role="form" method="post" action="<?php echo $GLOBALS['domain_root']; ?>/document/<?php echo $category->id; ?>">
                                        <div class="form-group col-lg-6 col-xs-12">
                                            <div>
                                                <div class="input-daterange input-group" id="date-range">
                                                    <input autocomplete="off" type="text" placeholder="Fecha Desde" class="form-control" name="datebegin" value="<?php echo $fecha_inicio; ?>" />
                                                    <span class="input-group-addon bg-primary text-white b-0">A</span>
                                                    <input autocomplete="off" type="text" placeholder="Fecha Hasta" class="form-control" name="dateend" value="<?php echo $fecha_fin; ?>" />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group search-box col-lg-6 col-xs-12">
                                            <input type="text" name="search" id="search-input" class="form-control product-search" placeholder="Nombre" value="<?php echo $nombre; ?>">
                                            <button type="submit" class="btn btn-search"><i class="fa fa-search"></i></button>
                                        </div>
                                        <div class="form-group col-lg-12 button-list text-right">
    
                                            <button type="submit" class="btn btn-success btn-rounded btn-md waves-effect waves-light m-b-30">Buscar</button>
                                            <button onClick="javascript:window.location='<?php echo $GLOBALS['domain_root']; ?>/document/<?php echo $category->id; ?>'" type="button" class="btn btn-default btn-rounded btn-md waves-effect waves-light m-b-30">Limpiar</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <?php 
                        if($count){ 
                            foreach($documents as $document){
                        ?>
                        <div class="col-lg-3 col-md-4 col-sm-6" >
                            <div class="card-box widget-box-one thumbnail" style="min-height:310px;">
                                <a rel="noopener noreferrer" target="_blank" href="<?php echo $GLOBALS['domain_root']; ?>/file/<?php echo $document->file; ?>">
                                    <h1 class="text-center text-danger"><i class="fa fa-file-pdf-o fa-2x"></i></h1>
                                    <div class="caption">
                                        <p class="m-t-15 text-uppercase font-600 font-secondary"><?php echo $document->name ?></p>
                                        <p class="m-t-15 text-uppercase font-secondary">Fecha: <?php echo $document->date ?></p>
                                    </div>
                                </a>
                            </div>
                        </div>
                        <?php        
                            }
                        }else{ ?>
                        <h2 class="text-center">No hay registros</h2>
                        <?php } ?>
                        <div class="clearfix"></div>
                        <div class="text-right">
                            <ul class="pagination m-t-0">
                                <?php echo $pag->print_paginator(); ?>
                            </ul>
                        </div>
                    </div>
                    <div class="card-box col-lg-3 col-md-6 col-xs-12">
                        <?php 
                        if(count($categories['registers'])){ 
                            foreach($categories['registers'] as $category){
                        ?>
                        <div class="media">
                            <a href="<?php echo $GLOBALS['domain_root']; ?>/document/<?php echo $category->id; ?>"> 
                                <img src="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/images/icon/<?php echo $category->ico; ?>" alt="<?php echo $category->name ?>" height="30px" class="pull-left"> 
                                <h5 class="text-left" style="padding-left:35px;"><?php echo $category->name ?></h5>
                            </a>
                        </div>
                        <hr>
                        <?php        
                            }
                        }else{ ?>
                        <h2 class="text-center">No hay registros</h2>
                        <?php } ?>
                    </div>
                </div>
                <?php require_once "template/manager/footer.php";?>
            </div>
        </div>
        <?php require_once "template/manager/js.php";?>
        <script src="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/plugins/bootstrap-select/js/bootstrap-select.min.js" type="text/javascript"></script>
        <script src="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
        <script>
			$(document).ready(function(e) {
				$('#date-range').datepicker({
					toggleActive: true,
					format: 'd-m-yyyy'
				});
			});
		</script>
    </body>
</html>
