<?php
require_once "configuracion/inicio.php";

use src\domain\user\UserRepository;
use src\application\user\UserGetRequest;
use src\application\category\CategoryList;
use src\infrastructure\sql\SqlUserRepository;
use src\application\category\CategoryListRequest;
use src\infrastructure\sql\SqlCategoryRepository;

$typeUserValid = array(2,3);

require_once "configuracion/validar_sesion.php";

$categoryRepository = new SqlCategoryRepository();

$request = new CategoryListRequest(array('status'=>1),array());
$categoryList = new CategoryList($categoryRepository);
$categories = $categoryList->execute($request);

?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <?php require_once "template/manager/head.php";?>
    </head>
    <body>
		<?php
		require_once "template/preloader.php";
		require_once "template/header.php";
		?>
        <div class="wrapper">
            <div class="container m-t-40">
                <h2 class="text-center">Bienvenido</h2>
                <div class="row text-center">

                    <?php 
                    if(count($categories['registers'])){ 
                        foreach($categories['registers'] as $category){
                    ?>
                    <div class="col-lg-2 col-md-4 col-sm-6">
                        <div class="card-box widget-box-one thumbnail" style="min-height:260px;">
                            <a href="<?php echo $GLOBALS['domain_root']; ?>/document/<?php echo $category->id; ?>">
                                <img src="<?php echo $GLOBALS['domain_root']; ?>/admin/assets/images/icon/<?php echo $category->ico; ?>" alt="<?php echo $category->name ?>" class="img-responsive thumb-lg">
                                <div class="caption">
                                    <p class="m-t-15 text-uppercase font-600 font-secondary"><?php echo $category->name ?></p>
                                </div>
                            </a>
                        </div>
                    </div>
                    <?php        
                        }
                    }else{ ?>
                    <h2 class="text-center">No hay registros</h2>
                    <?php } ?>
                </div>
                <?php require_once "template/manager/footer.php";?>
            </div>
        </div>
        <?php require_once "template/manager/js.php";?>
    </body>
</html>
