<?php
namespace configuracion;
//error_reporting(E_ERROR | E_WARNING | E_PARSE);
header('Access-Control-Allow-Origin: *');

spl_autoload_register(function ($clase) {
	$ds = DIRECTORY_SEPARATOR;
	require_once ROOT.str_replace('\\', $ds,$clase).'.php';
});

session_start();

define('ROOT', dirname(dirname(__FILE__)).DIRECTORY_SEPARATOR);

$userLogin = '';

$RAIZ = $_SERVER['DOCUMENT_ROOT']."/documents";

$GLOBALS['app_root'] = $_SERVER['DOCUMENT_ROOT']."/documents";

$GLOBALS['domain_root'] = "https://".$_SERVER['HTTP_HOST']."/documents";


define('TIEMPO_MAXIMO_SESION', 3600);

if(!empty($_SESSION["cart_metro"])){
	$cart = $_SESSION["cart_metro"];
}

function getRealIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP']))
        return $_SERVER['HTTP_CLIENT_IP'];

    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))
        return $_SERVER['HTTP_X_FORWARDED_FOR'];

    return $_SERVER['REMOTE_ADDR'];
}

define('IP', getRealIP());

function ObtenerNavegador($user_agent) {
     if(strpos($user_agent, 'MSIE') !== FALSE)
	   return 'Internet explorer';
	 elseif(strpos($user_agent, 'Edge') !== FALSE) //Microsoft Edge
	   return 'Microsoft Edge';
	 elseif(strpos($user_agent, 'Trident') !== FALSE) //IE 11
		return 'Internet explorer';
	 elseif(strpos($user_agent, 'Opera Mini') !== FALSE)
	   return "Opera Mini";
	 elseif(strpos($user_agent, 'Opera') || strpos($user_agent, 'OPR') !== FALSE)
	   return "Opera";
	 elseif(strpos($user_agent, 'Firefox') !== FALSE)
	   return 'Mozilla Firefox';
	 elseif(strpos($user_agent, 'Chrome') !== FALSE)
	   return 'Google Chrome';
	 elseif(strpos($user_agent, 'Safari') !== FALSE)
	   return "Safari";
	 else
	   return 'Desconocido';
}

define('NAVEGADOR', ObtenerNavegador($_SERVER['HTTP_USER_AGENT']));

// define('LANG',substr($_SERVER["HTTP_ACCEPT_LANGUAGE"],0,2));
define('LANG',"es");

setlocale(LC_TIME, 'es_ES.UTF-8');
// En windows
setlocale(LC_TIME, 'spanish');
?>
