<?php

require_once "../../configuracion/inicio.php";

use src\application\user\UserRequest;
use src\application\user\UserGetRequest;
use src\application\exception\UserInvalid;
use src\application\user\UserChangeStatus;
use src\application\exception\SessionExpire;
use src\application\media\UploadFileRequest;
use src\application\provider\ProviderCreate;
use src\application\provider\ProviderDelete;
use src\application\provider\ProviderUpdate;
use src\application\provider\ProviderRequest;
use src\infrastructure\sql\SqlUserRepository;
use src\infrastructure\media\BasicMediaUpload;
use src\application\provider\ProviderGetRequest;
use src\application\media\UploadFileExcelService;
use src\application\provider\ProcessDataExcelProvider;


$result = array("success"=>false,"data"=>"","message"=>"Ha ocurrido un error, por favor int&eacute;ntelo mas tarde");
$UserRepository = new SqlUserRepository();
$data = (json_decode(file_get_contents("php://input"),true)) ? json_decode(file_get_contents("php://input"),true) : $_POST;
$status = 0;
$mediaUpload = new BasicMediaUpload();
$userRepository = new SqlUserRepository();

if($data["empty"] == ""){
    try{

        if(isset($_POST["import-provider"])){

            $request = new UploadFileRequest($_FILES['file']);
            $uploadFile = new UploadFileExcelService($mediaUpload);
            $file = $uploadFile->execute($request);
            $processData = new ProcessDataExcelProvider(
                            $userRepository
                        );
            $resultExcel = $processData->execute($file['nameFile'],$_POST['type']);
            $result['success'] = true;
            $result['data'] = $resultExcel;
            $result['message'] = '';
            
        }
        if(isset($_POST["create-provider"])){

            $request = new ProviderRequest($_POST['name'],$_POST['email'],$_POST['ci'],intval($_POST['id']),intval($_POST['type']),0);
            $userCreate = new ProviderCreate( $UserRepository);
            $result = $userCreate->execute($request);

        }
        if(isset($_POST["update-provider"])){

            $request = new ProviderRequest($_POST['name'],$_POST['email'],$_POST['ci'],intval($_POST['id']),intval($_POST['type']),0);
            $userUpdate = new ProviderUpdate( $UserRepository);
            $result = $userUpdate->execute($request);

        }
        if(isset($_POST["change-status-provider"])){

            $request = new UserRequest(intval($_POST['id']),'','',$_POST['status'],'',0);
            $userChangeStatus = new UserChangeStatus( $UserRepository );
            $result = $userChangeStatus->execute($request);

        }
        if(isset($_POST["delete"])){

            $request = new ProviderGetRequest(intval($_POST['id']),'id');
            $deleteProvider = new ProviderDelete( $UserRepository );
            $result = $deleteProvider->execute($request);

        }

    }catch(\Exception $e){

        $result["message"] = $e->getMessage();

    }
}

echo json_encode($result);

?>
