<?php

require_once "../../configuracion/inicio.php";

use src\utils\Helper;
use src\infrastructure\email\Email;
use src\application\exception\UserInvalid;
use src\application\media\DeletePdfService;
use src\application\media\UploadPdfService;
use src\application\document\DocumentCreate;
use src\application\document\DocumentDelete;
use src\application\document\DocumentUpdate;
use src\application\exception\SessionExpire;
use src\application\media\UploadFileRequest;
use src\application\validation\ValidFilePdf;
use src\application\document\DocumentRequest;
use src\infrastructure\sql\SqlUserRepository;
use src\infrastructure\media\BasicMediaUpload;
use src\application\media\UploadFileExcelService;
use src\application\validation\ValidationRequest;
use src\infrastructure\sql\SqlCategoryRepository;
use src\infrastructure\sql\SqlDocumentRepository;
use src\application\document\DocumentChangeStatus;


$result = array("success"=>false,"message"=>"Ha ocurrido un error, por favor int&eacute;ntelo mas tarde");
$categoryRepository = new SqlCategoryRepository();
$documentRepository = new SqlDocumentRepository();
$UserRepository = new SqlUserRepository();
$emailSender = new Email();
$helper = new Helper();
$mediaUpload = new BasicMediaUpload();
$nameFile = '';
$provider = array();
$data = (json_decode(file_get_contents("php://input"),true)) ? json_decode(file_get_contents("php://input"),true) : $_POST;

if($data["empty"] == ""){
    try{

        if(isset($_POST['provider'])){

            $provider = $_POST['provider'];

        }

        if(isset($_POST["create-document"])){

            $nameFile = explode('.',($_FILES['file']['name']));
            $requestValid = new ValidationRequest(-1,$helper->friendlyUrl($nameFile[0]).'.pdf');
            $validPdf = new ValidFilePdf( $documentRepository );
            $resultValid = $validPdf->execute($requestValid);

            if(!$resultValid['success']){

                $request = new UploadFileRequest($_FILES['file']);
                $uploadFile = new UploadPdfService($mediaUpload);
                $file = $uploadFile->execute($request);
                $request = new DocumentRequest(0,$_POST['name'],$file['nameFile'],$_POST['category'],$provider,intval($_POST['type_user']),$_POST['date'],1);
                $documentCreate = new DocumentCreate($emailSender,$documentRepository, $categoryRepository, $UserRepository );
                $result = $documentCreate->execute($request);

            }else{

                throw new \Exception($resultValid['message']);

            }


        }
        if(isset($_POST["update-document"])){

            $nameFile = $_FILES['file']['name'];
            if($nameFile != ''){

                $nameFile = explode('.',($nameFile));
                $requestValid = new ValidationRequest(-1,$helper->friendlyUrl($nameFile[0]).'.pdf');
                $validPdf = new ValidFilePdf( $documentRepository );
                $resultValid = $validPdf->execute($requestValid);

                if(!$resultValid['success']){

                    $request = new UploadFileRequest($_FILES['file']);
                    $uploadFile = new UploadPdfService($mediaUpload);
                    $file = $uploadFile->execute($request);
                    $nameFile = $file['nameFile'];

                }else{

                    throw new \Exception($resultValid['message']);

                }       

            }


            $request = new DocumentRequest(intval($_POST['id']),$_POST['name'],$nameFile,$_POST['category'],$provider,intval($_POST['type_user']),$_POST['date'],1);
            $documentUpdate = new DocumentUpdate( $emailSender,$documentRepository, $categoryRepository, $UserRepository );
            $result = $documentUpdate->execute($request);

        }
        if(isset($_POST["change-status-document"])){

            $request = new DocumentRequest(intval($_POST['id']),'','','',array(),0,'',$_POST['status']);
            $documentChangeStatus = new DocumentChangeStatus( $emailSender,$documentRepository, $categoryRepository, $UserRepository );
            $result = $documentChangeStatus->execute($request);

        }
        if(isset($_POST["delete-document"])){

            $request = new DocumentRequest(intval($_POST['id']),'','','',array(),0,'',0);
            $documentDelete = new DocumentDelete( $emailSender,$documentRepository, $categoryRepository, $UserRepository );
            $result = $documentDelete->execute($request);
            
            if($result['success']){

                $request = new UploadFileRequest(array('name'=>$result['file']));
                $deleteFile = new DeletePdfService($mediaUpload);
                $delete = $deleteFile->execute($request);
            }

        }

    }catch(\Exception $e){

        $result["message"] = $e->getMessage();

    }
}


echo json_encode($result);

?>
