<?php
namespace api\manager;

require_once "../../configuracion/inicio.php";
require_once "../../configuracion/validar_sesion.php";

use configuracion;
configuracion\check_sesion(array(1,2));
$userLogin = configuracion\checkUserLogin($userLogin);

use clases\Orden_Product;
use clases\Product;

$result = $options = $ordenProducts = array();

if(!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest'){

	try{

        if(($_POST['databegin'] != '') && ($_POST['dataend'] != '') ){

            $options['date_register'] = date('Y-m-d',strtotime($_POST['databegin'])).','.date('Y-m-d',strtotime($_POST['dataend']));

        }

        $ordenProducts = Orden_Product::buscador($options,-1,-1);

        if(count($ordenProducts) > 0){

            foreach ($ordenProducts as $index => $data) {

                $product = Product::getProduct('id',$this->product);
                $result[$index]['date'] = date('m-d-Y',strtotime($data->Getdate_r()));
                $result[$index]['product'] = $data->name_product;
                $result[$index]['upc'] = $product->upc;
                $result[$index]['item'] = $product->item;
                $result[$index]['price'] = $data->price;
                $result[$index]['unit'] = $data->quantity_unit + $data->quantity;
                $result[$index]['case'] = $data->quantity_case;

            }

        }

	}catch(\Exception $e){

		$result[1] = $e->getMessage();

    }
}

echo json_encode($result);

?>
