<?php

require_once "../../configuracion/inicio.php";

use src\application\exception\UserInvalid;
use src\application\category\CategoryCreate;
use src\application\category\CategoryDelete;
use src\application\category\CategoryUpdate;
use src\application\exception\SessionExpire;
use src\application\category\CategoryRequest;
use src\infrastructure\sql\SqlProviderRepository;
use src\infrastructure\sql\SqlCategoryRepository;
use src\application\category\CategoryChangeStatus;


$result = array("success"=>false,"message"=>"Ha ocurrido un error, por favor int&eacute;ntelo mas tarde");
$categoryRepository = new SqlCategoryRepository();

$data = (json_decode(file_get_contents("php://input"),true)) ? json_decode(file_get_contents("php://input"),true) : $_POST;

if($data["empty"] == ""){
    try{

        if(isset($_POST["create-category"])){

            $request = new CategoryRequest(0,$_POST['name'],$_POST['ico'],1);
            $categoryCreate = new CategoryCreate( $categoryRepository);
            $result = $categoryCreate->execute($request);

        }
        if(isset($_POST["update-category"])){

            $request = new CategoryRequest(intval($_POST['id']),$_POST['name'],$_POST['ico'],1);
            $categoryUpdate = new CategoryUpdate( $categoryRepository);
            $result = $categoryUpdate->execute($request);

        }
        if(isset($_POST["change-status-category"])){

            $request = new CategoryRequest(intval($_POST['id']),'','',$_POST['status']);
            $categoryChangeStatus = new CategoryChangeStatus( $categoryRepository);
            $result = $categoryChangeStatus->execute($request);

        }
        if(isset($_POST["delete-category"])){

            $request = new CategoryRequest(intval($_POST['id']),'','',0);
            $categoryDelete = new CategoryDelete( $categoryRepository);
            $result = $categoryDelete->execute($request);

        }

    }catch(\Exception $e){

        $result["message"] = $e->getMessage();

    }
}


echo json_encode($result);

?>
