$(document).ready(function () {

	$('.selectpicker').selectpicker();
	
	$('.selectpicker').selectpicker();
	
	const addRowTable = (row) => {

		let classLabel = ( row['success'] == true ) ? 'label-success' : 'label-danger';

		let rowCell = `<tr>
			<td>${ row['name'] }</td>
			<td>${ row['ci'] }</td>
			<td>${ row['email'] }</td>
			<td>${ '<span class="label '+ classLabel +'">'+row['result']+'</span>' }</td>
		</tr>`;

		$('#tableResult tbody').append(rowCell);

	}

	if($('#form-import').length){

		$("#form-import").validate({
			rules:{
				file:{extension: "xls|xlsx"}
			},
			errorClass:'text-danger',
			submitHandler: function(form) {
				var datos = new FormData(form);
				$.ajax({
					type: "POST",
					data:datos,
					dataType:"json",
					url:urlPage+"/api/manager/provider.php",
					cache: false,
					contentType: false,
					processData: false,
					beforeSend: function(){
						$('#tableResult tbody').html('');
						$('#result').addClass('hide');
						beforeAjaxSend("form-import");
					},
					success: function (response){

						if(response["success"]){

							response["data"].forEach( addRowTable );
							$('#tableResult').DataTable({
								'searching':false,
								'destroy':true,
								"language": {
									"lengthMenu": "_MENU_ registros",
									"info": "_PAGE_ de _PAGES_",
									"paginate": {
										"first":"<<",
										"last": ">>",
										"next": ">",
										"previous": "<"
									},
								}
							});
							$('#result').removeClass('hide');

						}else{
							toastr.error(response["message"]);
						}
						afterAjaxSend("form-import");
					},
					error: function () {
						toastr.error("Ha ocurrido un error. Por favor intentelo mas tarde");
						afterAjaxSend("form-import");
					},
				});
			  }
		});

	}

	$.validator.addMethod("email_existe", function(value, element){
		var email_existe = $.ajax({
								type: "POST",
								url: urlPage+"/api/manager/valid.php",
								data: {email:value,id:$(element).data("id"),user:1},
								async: false,
							 }).responseText;
		if(email_existe == 'false'){
			return true;
		}else{
			return false;
		}

	}, "El email ya se encuentra registrado");
	
	$.validator.addMethod("ci_existe", function(value, element){
		var email_existe = $.ajax({
								type: "POST",
								url: urlPage+"/api/manager/valid.php",
								data: {ci:value,id:$(element).data("id"),user:1},
								async: false,
							 }).responseText;
		if(email_existe == 'false'){
			return true;
		}else{
			return false;
		}

	}, "El RIF ya se encuentra registrada");


	var formValidator = $("#form-user").validate({
                            errorClass:'text-danger',
							rules:{
								email:{required:true,email:true,"email_existe":true},
								ci:{required:true,"ci_existe":true},
							},
							submitHandler: function(form) {
								var datos = $("#form-user").serialize();
								$.ajax({
									type: "POST",
									data:datos,
									dataType:"json",
									url:urlPage+"/api/manager/provider.php",
									beforeSend: function(){
										beforeAjaxSend("form-user");
									},
									success: function (response){

										if(response["success"]){

											let folder = 'provider';

											if($('#type').val() == 3){

												folder = 'client';

											}

											if($('input[name="create-provider"]').length){
												
												window.location =urlPage+'/manager/'+folder+'/dashboard/msj/inserted';

											}
											if($('input[name="update-provider"]').length){
												
												window.location =urlPage+'/manager/'+folder+'/dashboard/msj/updated';

											}

										}else{
                                            toastr.error(response["message"]);
										}
                                        afterAjaxSend("form-user");
									},
									error: function () {
										toastr.error("Ha ocurrido un error. Por favor intentelo mas tarde");
										afterAjaxSend("form-user");
					        		},
								});
					  		}
						});		

	$("#tableRecord tbody").on("change", ".change-state",function(){

		var id = $(this).data("id");
		var estado = 0;
		if($(this).is(':checked')){
			estado = 1;
		}
		$.ajax({
			type: "POST",
			data:{
				"id":id,
				"change-status-provider":1,
				"status":estado,
				"empty":"",
			},
			dataType:"json",
			url:urlPage+"/api/manager/provider.php",
			success: function (response){
				if(response["success"]){
					if(estado == 0){
						$(".deleteRecord[data-id="+id+"]").removeClass("hide");
					}
					if(estado == 1){
						$(".deleteRecord[data-id="+id+"]").addClass("hide");
					}
					toastr.success('Registro modificado exitosamente');
				}
				if(response[0] == 1){
					toastr.error(response["message"]);
				}
			},

		});
	});		

	$(".deleteRecord").click(function(){
		var id = $(this).data("id");
			swal({
				title: "Confirmación",
				text: "¿Quiere eliminar este proveedor?",
			  	type: "warning",
			  	showCancelButton: true,
			  	confirmButtonClass: "btn-success",
			  	confirmButtonText: "Si",
			  	cancelButtonText: "No",
			  	closeOnConfirm: false,
			  	showLoaderOnConfirm: true
			},
			function(){
			  	$.ajax({
					type: "POST",
					data:{
						"id":id,
						"delete":1,
						"empty":""
					},
					dataType:"json",
					url:urlPage+"/api/manager/provider.php",
					success: function (response){
						window.location =urlPage+'/manager/provider/dashboard/msj/deleted';
					},
				});
			});

		
	});
});
