$(document).ready(function () {

	$('.selectpicker').selectpicker();
	

	if($('#date').length){

		$('#date').datepicker({
			format: 'd-m-yyyy'
		});

	}


    if($("#formFile").length){

        var formValidator = $("#formFile").validate({
								rules:{
									file:{extension: "pdf"}
								},
                                errorClass:'text-danger',
    							submitHandler: function(form) {
    								var datos = new FormData(form);
    								$.ajax({
    									type: "POST",
    									data:datos,
    									dataType:"json",
                                        cache: false,
                                        contentType: false,
                                        processData: false,
    									url:urlPage+"/api/manager/document.php",
                                        beforeSend: function(){
    										beforeAjaxSend("formCategory");
    									},
    									success: function (response){

    										if(response["success"]){

                                                if($('input[name="create-document"]').length){
												
													window.location =urlPage+'/manager/files/dashboard/msj/inserted';
	
												}
												if($('input[name="update-document"]').length){
													
													window.location =urlPage+'/manager/files/dashboard/msj/updated';
	
												}

    										}else{
                                                toastr.error(response["message"]);
    										}
                                            afterAjaxSend("formFile");
    									},
    									error: function () {
    										toastr.error("Ha ocurrido un error. Por favor intentelo mas tarde");
    										afterAjaxSend("formFile");
    					        		},

    								});

    					  		}
    						});


	}
	
	$('#type_user').change(function(){

		var type = $(this).val();
		$('#provider option').addClass('hide');

		if(type != ''){

			$('#provider option[data-type="'+type+'"]').removeClass('hide');

		}else{

			$('#provider option').removeClass('hide');

		}

		$('#provider').selectpicker('refresh');

	})

    if($('#nestable').length){

        $('#nestable .change-state').on('change', function (event) {

            event.preventDefault();
    		var id = $(this).data("id");
    		var estado = 0;
    		if($(this).is(':checked')){
    			estado = 1;
    		}
    		$.ajax({
    			type: "POST",
    			data:{
    				"id":id,
    				"change-status-document":1,
    				"status":estado,
    				"empty":"",
    			},
    			dataType:"json",
    			url:urlPage+"/api/manager/document.php",
    			success: function (response){
    				if(response["success"]){
    					if(estado == 0){
    						$(".deleteRecord[data-id="+id+"]").removeClass("hide");
    					}
    					if(estado == 1){
    						$(".deleteRecord[data-id="+id+"]").addClass("hide");
    					}
    					toastr.success('Registro actualizado exitosamente');
    				}else{
    					toastr.error(response["message"]);
    				}
    			},

    		});
    	});

    	$('#nestable .deleteRecord').on('click', function (event) {

            event.preventDefault();
    		var id = $(this).data("id");
    		var nombre = $("tr#category"+id+" .name").text();
    		if(!$(".change-state[data-id="+id+"]").is(':checked')){
    			swal({
				  title: "Confirmación",
				  text: "¿Quiere eliminar este registro?.",
				  type: "warning",
    			  showCancelButton: true,
    			  confirmButtonClass: "btn-success",
    			  confirmButtonText: "Si",
    			  cancelButtonText: "No",
    			  closeOnConfirm: false,
    			  showLoaderOnConfirm: true
    			},
    			function(){
    			  	$.ajax({
    					type: "POST",
    					data:{
    						"id":id,
    						"delete-document":1,
    						"empty":""
    					},
    					dataType:"json",
    					url:urlPage+"/api/manager/document.php",
    					success: function (response){
    						toastr.success('Registro eliminado exitosamente');
    						$("tr#file"+id).remove();
    						swal.close();
    					},
    				});
    			});

    		}else{
    			toastr.warning('El Registro se encuentra activo');
    		}
    	});

    }

});
