$(document).ready(function () {

    $('.selectpicker').selectpicker();

    if($("#formCategory").length){

        var formValidator = $("#formCategory").validate({
                                errorClass:'text-danger',
    							submitHandler: function(form) {
    								var datos = new FormData(form);
    								$.ajax({
    									type: "POST",
    									data:datos,
    									dataType:"json",
                                        cache: false,
                                        contentType: false,
                                        processData: false,
    									url:urlPage+"/api/manager/category.php",
                                        beforeSend: function(){
    										beforeAjaxSend("formCategory");
    									},
    									success: function (response){

    										if(response["success"]){

                                                if($('input[name="create-category"]').length){
												
													window.location =urlPage+'/manager/categories/dashboard/msj/inserted';
	
												}
												if($('input[name="update-category"]').length){
													
													window.location =urlPage+'/manager/categories/dashboard/msj/updated';
	
												}

    										}else{
                                                toastr.error(response["message"]);
    										}
                                            afterAjaxSend("formCategory");
    									},
    									error: function () {
    										toastr.error("Ha ocurrido un error. Por favor intentelo mas tarde");
    										afterAjaxSend("formCategory");
    					        		},

    								});

    					  		}
    						});


    }

    if($('#nestable').length){

        $('#nestable .change-state').on('change', function (event) {

            event.preventDefault();
    		var id = $(this).data("id");
    		var estado = 0;
    		if($(this).is(':checked')){
    			estado = 1;
    		}
    		$.ajax({
    			type: "POST",
    			data:{
    				"id":id,
    				"change-status-category":1,
    				"status":estado,
    				"empty":"",
    			},
    			dataType:"json",
    			url:urlPage+"/api/manager/category.php",
    			success: function (response){
    				if(response["success"]){
    					if(estado == 0){
    						$(".deleteRecord[data-id="+id+"]").removeClass("hide");
    					}
    					if(estado == 1){
    						$(".deleteRecord[data-id="+id+"]").addClass("hide");
    					}
    					toastr.success('Registro actualizado exitosamente');
    				}else{
    					toastr.error(response["message"]);
    				}
    			},

    		});
    	});

    	$('#nestable .deleteRecord').on('click', function (event) {

            event.preventDefault();
    		var id = $(this).data("id");
    		var nombre = $("tr#category"+id+" .name").text();
    		if(!$(".change-state[data-id="+id+"]").is(':checked')){
    			swal({
				  title: "Confirmación",
				  text: "¿Quiere eliminar "+nombre+"?. Al hacerlo se eliminaran todos los registros asociados",
				  type: "warning",
    			  showCancelButton: true,
    			  confirmButtonClass: "btn-success",
    			  confirmButtonText: "Yes",
    			  cancelButtonText: "No",
    			  closeOnConfirm: false,
    			  showLoaderOnConfirm: true
    			},
    			function(){
    			  	$.ajax({
    					type: "POST",
    					data:{
    						"id":id,
    						"delete-category":1,
    						"empty":""
    					},
    					dataType:"json",
    					url:urlPage+"/api/manager/category.php",
    					success: function (response){
    						toastr.success('Registro eliminado exitosamente');
    						$("tr#category"+id).remove();
    						swal.close();
    					},
    				});
    			});

    		}else{
    			toastr.warning('El Registro se encuentra activo');
    		}
    	});

    }

});
